/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.image.ColorThief;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.data.OreDictUniqueStackList;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class ItemColorizationHelper
implements IResourceManagerReloadListener {
    public static ItemColorizationHelper instance = new ItemColorizationHelper();
    private Table<Item, Integer, Color> colorizationMap = HashBasedTable.create();

    private ItemColorizationHelper() {
    }

    private void setupRegistry() {
        List<ItemStack> collect = this.collectNecessaryItemStacks();
        for (ItemStack stack : collect) {
            if (stack.func_190926_b()) continue;
            this.resolveColor(stack);
        }
    }

    private void resolveColor(ItemStack stack) {
        Color dominant = this.getDominantColorFromStack(stack);
        if (dominant != null) {
            this.colorizationMap.put((Object)stack.func_77973_b(), (Object)ItemColorizationHelper.getMeta(stack), (Object)dominant);
        }
    }

    private static int getMeta(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return stack.func_77960_j();
        }
        return stack.func_77952_i();
    }

    @Nullable
    public static Color getDominantColorFromItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        int dmg = ItemColorizationHelper.getMeta(stack);
        Color c = (Color)ItemColorizationHelper.instance.colorizationMap.get((Object)stack.func_77973_b(), (Object)dmg);
        if (c == null) {
            instance.resolveColor(stack);
        }
        return (Color)ItemColorizationHelper.instance.colorizationMap.get((Object)stack.func_77973_b(), (Object)dmg);
    }

    private List<ItemStack> collectNecessaryItemStacks() {
        TraitRecipe tr;
        OreDictUniqueStackList toPrepare = new OreDictUniqueStackList();
        for (AbstractAltarRecipe ar : AltarRecipeRegistry.getRecipesForLevel(TileAltar.AltarLevel.TRAIT_CRAFT)) {
            if (!(ar instanceof TraitRecipe)) continue;
            tr = (TraitRecipe)ar;
            toPrepare.add(tr.getOutputForRender());
            for (ItemHandle handle : tr.getTraitItemHandles()) {
                if (handle == null || handle.handleType == ItemHandle.Type.OREDICT) continue;
                toPrepare.addAll(handle.getApplicableItemsForRender());
            }
        }
        for (AbstractAltarRecipe ar : AltarRecipeRegistry.getRecipesForLevel(TileAltar.AltarLevel.ENDGAME)) {
            if (!(ar instanceof TraitRecipe)) continue;
            tr = (TraitRecipe)ar;
            toPrepare.add(tr.getOutputForRender());
            for (ItemHandle handle : tr.getTraitItemHandles()) {
                if (handle == null || handle.handleType == ItemHandle.Type.OREDICT) continue;
                toPrepare.addAll(handle.getApplicableItemsForRender());
            }
        }
        return toPrepare;
    }

    @Nullable
    private Color getDominantColorFromStack(ItemStack stack) {
        TextureAtlasSprite tas = RenderingUtils.tryGetMainTextureOfItemStack(stack);
        if (tas == null) {
            return null;
        }
        int overlay = this.getOverlayColor(stack);
        try {
            BufferedImage extractedImage = this.extractImage(tas);
            int[] dominantColor = ColorThief.getColor(extractedImage);
            int r = (int)((float)(dominantColor[0] - 1) * (float)(overlay >> 16 & 0xFF) / 255.0f);
            int g = (int)((float)(dominantColor[1] - 1) * (float)(overlay >> 8 & 0xFF) / 255.0f);
            int b = (int)((float)(dominantColor[2] - 1) * (float)(overlay >> 0 & 0xFF) / 255.0f);
            r = MathHelper.func_76125_a((int)r, (int)0, (int)255);
            g = MathHelper.func_76125_a((int)g, (int)0, (int)255);
            b = MathHelper.func_76125_a((int)b, (int)0, (int)255);
            return new Color(r, g, b).brighter();
        }
        catch (Exception exc) {
            AstralSorcery.log.error("Item Colorization Helper: Ignoring non-resolvable image " + tas.func_94215_i());
            exc.printStackTrace();
            return null;
        }
    }

    @Nullable
    private BufferedImage extractImage(TextureAtlasSprite tas) {
        int w = tas.func_94211_a();
        int h = tas.func_94216_b();
        int count = tas.func_110970_k();
        if (w <= 0 || h <= 0 || count <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(w, h * count, 6);
        for (int i = 0; i < count; ++i) {
            bufferedImage.setRGB(0, i * h, w, h, tas.func_147965_a(i)[0], 0, w);
        }
        return bufferedImage;
    }

    private int getOverlayColor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        if (stack.func_77973_b() instanceof ItemBlock) {
            IBlockState state = ItemUtils.createBlockState(stack);
            if (state == null) {
                return -1;
            }
            return Minecraft.func_71410_x().func_184125_al().func_186724_a(state, null, null, 0);
        }
        return Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 0);
    }

    private void nukeRegistry() {
        this.colorizationMap.clear();
    }

    public void reloadRegistry() {
        AstralSorcery.log.info("Item Colorization Helper: Rebuilding colorization cache! This might take longer for higher-res texture packs...");
        long startMs = System.currentTimeMillis();
        this.nukeRegistry();
        this.setupRegistry();
        AstralSorcery.log.info("Item Colorization Helper: Cache rebuilt! Time required: " + (System.currentTimeMillis() - startMs) + "ms - Entries cached: " + this.colorizationMap.size());
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.reloadRegistry();
    }
}

