/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.power;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.conduits.conduit.power.BasePowerConduitData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IPowerConduitData {
    public int getID();

    public int getMaxEnergyIO();

    @Nonnull
    public ItemStack createItemStackForSubtype();

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getTextureForState(@Nonnull CollidableComponent var1);

    public static class Registry {
        @Nonnull
        private static final List<IPowerConduitData> data = new ArrayList<IPowerConduitData>();
        @Nonnull
        private static final IPowerConduitData fallback = new BasePowerConduitData(0);

        @Nonnull
        public static IPowerConduitData fromID(int id) {
            return (IPowerConduitData)NullHelper.first((Object[])new IPowerConduitData[]{data.get(MathHelper.func_76125_a((int)id, (int)0, (int)(data.size() - 1))), fallback});
        }

        public static void register(@Nonnull IPowerConduitData pcd) {
            while (pcd.getID() >= data.size()) {
                data.add(null);
            }
            if (data.get(pcd.getID()) != null) {
                throw new RuntimeException("Cannot register power conduit with ID " + pcd.getID() + ".");
            }
            data.set(pcd.getID(), pcd);
        }

        static {
            Registry.register(fallback);
            Registry.register(new BasePowerConduitData(1));
            Registry.register(new BasePowerConduitData(2));
        }
    }
}

