/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.gui;

import com.enderio.core.client.gui.IDrawingElement;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.VecmathUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.gui.GuiContainerBaseEIO;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.gui.IPowerBarData;
import info.loenwind.scheduler.Celeb;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class PowerBar
implements IDrawingElement {
    @Nonnull
    private final IPowerBarData tank;
    @Nonnull
    private final GuiContainerBaseEIO owner;
    @Nonnull
    private final PowerBarTooltip tooltip;
    private int x;
    private int y;
    private int width;
    private int height;
    private static long langLastTick = 0L;
    private static final List<String> lang = Arrays.asList("Krismasi Njema", "UKhisimusi omuhle", "Moni Wa Chikondwelero Cha Kristmasi", "\u06a9\u0631\u0633\u0645\u0633 \u0645\u0628\u0627\u0631\u06a9", "G\u00ebzuar Krishtlindjen", "\u0639\u064a\u062f \u0645\u064a\u0644\u0627\u062f \u0645\u062c\u064a\u062f", "\u0547\u0576\u0578\u0580\u0570\u0561\u057e\u0578\u0580 \u0531\u0574\u0561\u0576\u0578\u0580 \u0587 \u054d\u0578\u0582\u0580\u0562 \u053e\u0576\u0578\u0582\u0576\u0564", "Vrolijk Kerstfeest", "djoyeus Noy\u00e9", "'vesela 'koleda", "\u5723\u8bde\u5feb\u4e50", "\u8056\u8a95\u5feb\u6a02", "Sretan Bo\u017ei\u0107", "Prejeme Vam Vesele Vanoce", "Gl\u00e6delig Jul", "Mbotama Malamu", "Feli\u0109an Kristnaskon", "R\u00f5\u00f5msaid J\u00f5ulup\u00fchi", "Hyv\u00e4\u00e4 Joulua", "Joyeux No\u00ebl", "Nedeleg Laouen", "Bon Natale", "Frohe Weihnachten", "Ni ti Burunya Chou", "Afishapa", "\u039a\u03b1\u03bb\u03ac \u03a7\u03c1\u03b9\u03c3\u03c4\u03bf\u03cd\u03b3\u03b5\u03bd\u03bd\u03b1", "\u10d2\u10d8\u10da\u10dd\u10ea\u10d0\u10d5 \u10e8\u10dd\u10d1\u10d0-\u10d0\u10ee\u10d0\u10da \u10ec\u10d4\u10da\u10e1", "Juullimi Pilluarit", "Mele Kalikimaka", "Prettig Kerstfeest", "Kellemes kar\u00e1csonyi \u00fcnnepeket", "Gle\u00f0ileg j\u00f3l", "\u0936\u0941\u092d \u0915\u094d\u0930\u093f\u0938\u092e\u0938", "\u06a9\u0631\u0633\u0645\u0633", "Krismasasya shubhkaamnaa", "\u0a86\u0aa8\u0a82\u0aa6\u0ac0 \u0aa8\u0abe\u0aa4\u0abe\u0ab2", "\u09b6\u09c1\u09ad \u09ac\u09dc\u09a6\u09bf\u09a8", "\u0b95\u0bbf\u0bb1\u0bbf\u0bb8\u0bcd\u0ba4\u0bc1\u0bae\u0bb8\u0bcd \u0bb5\u0bbe\u0bb4\u0bcd\u0ba4\u0bcd\u0ba4\u0bc1\u0b95\u0bcd\u0b95\u0bb3\u0bcd", "Khushal Borit Natala", "\u0c95\u0ccd\u0cb0\u0cbf\u0cb8\u0ccd \u0cae\u0cb8\u0ccd \u0cb9\u0cac\u0ccd\u0cac\u0ca6 \u0cb6\u0cc1\u0cad\u0cbe\u0cb7\u0caf\u0c97\u0cb3\u0cc1", "Krismas Chibai", "\u0936\u0941\u092d \u0928\u093e\u0924\u093e\u0933", "\u0a15\u0a30\u0a3f\u0a38\u0a2e \u0a24\u0a47 \u0a28\u0a35\u0a3e\u0a70 \u0a38\u0a3e\u0a32 \u0a16\u0a41\u0a38\u0a3c\u0a3f\u0a2f\u0a3e\u0a70\u0a35\u0a3e\u0a32\u0a3e \u0a39\u0a4b\u0a35\u0a47", "Christmas inte mangalaashamsakal", "Christmas Subhakankshalu", "Selamat Natal", "Christmas MobArak", "Kir\u00eesmes u ser sala we p\u00eeroz be", "Nollaig Shona Dhuit", "\u05d7\u05d2 \u05de\u05d5\u05dc\u05d3 \u05e9\u05de\u05d7", "Buon Natale", "Bon Natali", "\u3081\u308a\u30fc\u304f\u308a\u3059\u307e\u3059", "\uba54\ub9ac \ud06c\ub9ac\uc2a4\ub9c8\uc2a4", "Priec\u00efgus Ziemassv\u00batkus", "Linksm\u0173 Kal\u0117d\u0173", "\u0421\u0440\u0435\u045c\u0435\u043d \u0411\u043e\u0436\u0438\u043a", "Tratra ny Noely", "Il-Milied it-Tajjeb", "Selamat Hari Natal", "Puthuvalsara Aashamsakal", "Gozhqq Keshmish", "Nizhonigo Keshmish", "Quvianagli Anaiyyuniqpaliqsi", "Alussistuakeggtaarmek", "\u0915\u094d\u0930\u0938\u094d\u092e\u0938\u0915\u094b \u0936\u0941\u092d\u0915\u093e\u092e\u0928\u093e", "Meri Kirihimete", "barka d\u00e0 Kirs\u00ecmat\u00ec", "E ku odun", "Jabbama be salla Kirismati", "E keresimesi Oma", "Iselogbe", "Idara ukapade isua", "God Jul", "Maligayang Pasko", "Naragsak Nga Paskua", "Malipayon nga Pascua", "Maayong Pasko", "Maugmang Pasko", "Maabig ya pasko", "Weso\u0142ych \u015awi\u0105t Bo\u017cego Narodzenia", "Feliz Natal", "Cr\u1eb7ciun Fericit", "C \u0440\u043e\u0436\u0434\u0435\u0441\u0442\u0432\u043e\u043c", "Noheli nziza", "Manuia Le Kerisimasi", "Blithe Yule", "Nollaig Chridheil", "\u0425\u0440\u0438\u0441\u0442\u043e\u0441 \u0441\u0435 \u0440\u043e\u0434\u0438", "Vesele Vianoce", "Vesel Bo\u017ei\u010d", "Kirismas Wacan", "Gese\u00ebnde Kersfees", "Feliz Navidad", "Bon Nadal", "Bo Nadal", "Eguberri on", "Sch\u00f6ni Wiehnachte", "Suk sarn warn Christmas", "Mutlu Noeller", "Seku Kulu", "\u0412\u0435\u0441\u0435\u043b\u043e\u0433\u043e \u0420\u0456\u0437\u0434\u0432\u0430 \u0456 \u0437 \u041d\u043e\u0432\u0438\u043c \u0420\u043e\u043a\u043e\u043c", "Chu\u0107 M\u01b0\u01f9g Gia\u0144g Sinh", "Nadolig Llawen", "Muve neKisimusi", "Izilokotho Ezihle Zamaholdeni", "toDwI'ma' qoS yItIvqu'", "Alass\u00eb a Hristomerend\u00eb", "Mereth Veren e-Doled Eruion", "Politically Correct Season Greetings");

    public PowerBar(@Nonnull IPowerBarData tank, @Nonnull GuiContainerBaseEIO owner, int height) {
        this(tank, owner, -1, -1, -1, height);
    }

    public PowerBar(@Nonnull IPowerBarData tank, @Nonnull GuiContainerBaseEIO owner) {
        this(tank, owner, -1, -1, -1, -1);
    }

    public PowerBar(@Nonnull IPowerBarData tank, @Nonnull GuiContainerBaseEIO owner, int x, int y) {
        this(tank, owner, x, y, -1, -1);
    }

    public PowerBar(@Nonnull IPowerBarData tank, @Nonnull GuiContainerBaseEIO owner, int x, int y, int height) {
        this(tank, owner, x, y, -1, height);
    }

    public PowerBar(@Nonnull IPowerBarData tank, @Nonnull GuiContainerBaseEIO owner, int x, int y, int width, int height) {
        this.tank = tank;
        this.owner = owner;
        this.x = x > 0 ? x : 16;
        this.y = y > 0 ? y : 14;
        this.width = width > 0 ? width : 9;
        this.height = height > 0 ? height : 42;
        this.tooltip = new PowerBarTooltip();
    }

    @Nullable
    public GuiToolTip getTooltip() {
        return this.tooltip;
    }

    protected String getPowerOutputLabel(@Nonnull String rft) {
        return Lang.GUI_GENERIC_MAX.get(rft);
    }

    protected String getPowerLossLabel(@Nonnull String rft) {
        return Lang.GUI_GENERIC_LOSS.get(rft);
    }

    public void drawGuiContainerBackgroundLayer(float partialTicks, int par2, int par3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)"enderio:textures/gui/overlay.png");
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        int guiX0 = this.owner.getGuiLeft();
        int guiY0 = this.owner.getGuiTop();
        if (this.tank.getCapacitorData() == DefaultCapacitorData.NONE) {
            this.paintCapacitorError(guiX0, guiY0);
        } else {
            this.paintPowerBar(guiX0, guiY0);
            if (Celeb.C24.isOn() && PersonalConfig.celebrateChristmas.get().booleanValue()) {
                this.paintC24Overlay(guiX0, guiY0);
            }
        }
        this.owner.bindGuiTexture();
        GlStateManager.func_179084_k();
    }

    private void paintC24Overlay(int guiX0, int guiY0) {
        int drawX = guiX0 + this.x;
        int barWidth = this.width;
        int fullBarHeight = this.height;
        int drawYfullBar = guiY0 + (this.y + this.height) - fullBarHeight;
        int c24Frame = (int)(EnderIO.proxy.getTickCount() / 3L % 25L);
        int drawUc24 = c24Frame * 10;
        boolean drawVc24 = false;
        this.owner.func_73729_b(drawX, drawYfullBar, drawUc24, 0, barWidth, fullBarHeight);
    }

    private int getEnergyStoredScaled(int scale) {
        int maxEnergyStored = this.tank.getMaxEnergyStored();
        int energyStored = this.tank.getEnergyStored();
        return maxEnergyStored == 0 || energyStored == 0 ? 0 : VecmathUtil.clamp((int)Math.round((float)scale * ((float)energyStored / (float)maxEnergyStored)), (int)1, (int)scale);
    }

    private void paintPowerBar(int guiX0, int guiY0) {
        int drawX = guiX0 + this.x;
        int barWidth = this.width;
        int barHeight = this.getEnergyStoredScaled(this.height);
        int barFrame = (int)(EnderIO.proxy.getTickCount() / 3L % 20L);
        if (barFrame > 10) {
            barFrame = 20 - barFrame;
        }
        int yOffset = this.y + this.height - barHeight;
        int drawY = guiY0 + yOffset;
        int drawU = barFrame * 10;
        int drawV = 128;
        this.owner.func_73729_b(drawX, drawY, drawU, 128, barWidth, barHeight);
        while (barHeight > 64) {
            this.drawShimmer(drawX, drawY, barWidth, 64, 1);
            this.drawShimmer(drawX, drawY, barWidth, 64, 5);
            drawY += 64;
            barHeight -= 64;
        }
        this.drawShimmer(drawX, drawY, barWidth, barHeight, 1);
        this.drawShimmer(drawX, drawY, barWidth, barHeight, 5);
    }

    private void drawShimmer(int drawX, int drawY, int barWidth, int barHeight, int speed) {
        int overlayFrame = (int)(EnderIO.proxy.getTickCount() / (long)speed % 128L);
        int drawUoverlay = 128;
        int drawVoverlay = 128 + overlayFrame;
        if (drawVoverlay + barHeight > 255) {
            drawUoverlay += 10;
            drawVoverlay -= 64;
        }
        this.owner.func_73729_b(drawX, drawY, drawUoverlay, drawVoverlay, barWidth, barHeight);
    }

    private void paintCapacitorError(int guiX0, int guiY0) {
        int drawX = guiX0 + this.x;
        int drawY = guiY0 + this.y + 16 - 6;
        int barWidth = this.width;
        int barHeight = this.height;
        int textureHeight = 24;
        int overlayFrame = (int)((EnderIO.proxy.getTickCount() >>> 2) % 5L);
        int drawUoverlay = 160 + overlayFrame * 9;
        int drawVoverlay = 128;
        int barY = drawY + barHeight - 24;
        this.owner.func_73729_b(drawX, barY, drawUoverlay, 128, barWidth, 24);
        int stackX = drawX + barWidth / 2 - 8;
        int stackY = drawY + barHeight - 24 - 13;
        GlStateManager.func_179094_E();
        float f1 = MathHelper.func_76126_a((float)(((float)EnderIO.proxy.getTickCount() + Minecraft.func_71410_x().func_184121_ak()) / 10.0f)) * 4.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)f1, (float)0.0f);
        this.owner.drawFakeItemStack(stackX, stackY, new ItemStack(ModObject.itemBasicCapacitor.getItemNN()));
        GlStateManager.func_179121_F();
    }

    public class PowerBarTooltip
    extends GuiToolTip {
        public PowerBarTooltip() {
            super(new Rectangle(PowerBar.this.x, PowerBar.this.y, PowerBar.this.width, PowerBar.this.height), new String[0]);
        }

        protected void updateText() {
            this.text.clear();
            if (Celeb.C24.isOn() && PersonalConfig.celebrateChristmas.get().booleanValue()) {
                long currentTick = EnderIO.proxy.getTickCount() / 30L;
                if (langLastTick != currentTick) {
                    langLastTick = currentTick;
                    Collections.shuffle(lang);
                }
                this.text.add(lang.get(0));
            }
            if (PowerBar.this.tank.getCapacitorData() == DefaultCapacitorData.NONE) {
                this.text.addAll(Lang.GUI_NOCAP.getLines(new Object[0]));
            } else {
                this.text.add(PowerBar.this.getPowerOutputLabel(LangPower.RFt(PowerBar.this.tank.getMaxUsage())));
                float powerLossPerTick = PowerBar.this.tank.getPowerLossPerTick();
                if (powerLossPerTick > 0.0f) {
                    this.text.add(PowerBar.this.getPowerLossLabel(LangPower.RFt2(powerLossPerTick)));
                }
                this.text.add(LangPower.RF(PowerBar.this.tank.getEnergyStored(), PowerBar.this.tank.getMaxEnergyStored()));
            }
        }
    }
}

