/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.speed;

import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.config.factory.IValue;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.potion.PotionUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class SpeedUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "speedBoost";
    private static final String[] numbers = new String[]{"one", "two", "three"};
    @Nonnull
    public static final SpeedUpgrade SPEED_ONE = new SpeedUpgrade(1);
    @Nonnull
    public static final SpeedUpgrade SPEED_TWO = new SpeedUpgrade(2);
    @Nonnull
    public static final SpeedUpgrade SPEED_THREE = new SpeedUpgrade(3);
    private final short level;

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)SPEED_ONE);
        event.getRegistry().register((IForgeRegistryEntry)SPEED_TWO);
        event.getRegistry().register((IForgeRegistryEntry)SPEED_THREE);
    }

    public static SpeedUpgrade loadAnyFromItem(@Nonnull ItemStack stack) {
        if (SPEED_THREE.hasUpgrade(stack)) {
            return SPEED_THREE;
        }
        if (SPEED_TWO.hasUpgrade(stack)) {
            return SPEED_TWO;
        }
        if (SPEED_ONE.hasUpgrade(stack)) {
            return SPEED_ONE;
        }
        return null;
    }

    public static boolean isEquipped(@Nonnull EntityPlayer player) {
        return SpeedUpgrade.loadAnyFromItem(player.func_184582_a(EntityEquipmentSlot.LEGS)) != null;
    }

    @Nonnull
    private static ItemStack createUpgradeItem() {
        return PotionUtil.createSwiftnessPotion(true, false);
    }

    public SpeedUpgrade(int level) {
        super(UPGRADE_NAME, level, "enderio.darksteel.upgrade.speed_" + numbers[level - 1], SpeedUpgrade.createUpgradeItem(), (IValue<Integer>)((IValue)DarkSteelConfig.speedUpgradeCost.get(level - 1)));
        this.level = (short)level;
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        if (!item.isForSlot(EntityEquipmentSlot.LEGS) || !EnergyUpgradeManager.itemHasAnyPowerUpgrade(stack)) {
            return false;
        }
        SpeedUpgrade up = SpeedUpgrade.loadAnyFromItem(stack);
        if (up == null) {
            return this.getLevel() == 1;
        }
        return up.getLevel() == this.getLevel() - 1;
    }

    public short getLevel() {
        return this.level;
    }

    @Override
    public boolean isUpgradeItem(@Nonnull ItemStack stack) {
        return super.isUpgradeItem(stack) && PotionUtils.func_185191_c((ItemStack)this.getUpgradeItem()).equals(PotionUtils.func_185191_c((ItemStack)stack));
    }
}

