/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming;

import com.enderio.core.common.util.OreDictionaryHelper;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.api.farm.IFarmingTool;
import crazypants.enderio.base.item.darksteel.ItemDarkSteelTreetap;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public enum FarmingTool implements IFarmingTool
{
    HAND(new String[0]),
    HOE(new String[0]){

        @Override
        protected boolean match(@Nonnull ItemStack item) {
            return item.func_77973_b() instanceof ItemHoe || OreDictionaryHelper.hasName((ItemStack)item, (String)"toolHoe");
        }
    }
    ,
    AXE(new String[0]){

        @Override
        protected boolean match(@Nonnull ItemStack item) {
            return item.func_77973_b().getHarvestLevel(item, "axe", null, null) >= 0;
        }
    }
    ,
    TREETAP(new String[0]){

        @Override
        protected boolean match(@Nonnull ItemStack item) {
            return super.match(item) || item.func_77973_b() instanceof ItemDarkSteelTreetap || OreDictionaryHelper.hasName((ItemStack)item, (String)"toolTreetap");
        }
    }
    ,
    SHEARS(new String[0]){

        @Override
        protected boolean match(@Nonnull ItemStack item) {
            return item.func_77973_b() instanceof ItemShears || OreDictionaryHelper.hasName((ItemStack)item, (String)"toolShears");
        }
    }
    ,
    NONE(new String[0]){

        @Override
        protected boolean match(@Nonnull ItemStack item) {
            return false;
        }
    };

    @Nonnull
    private final Things things;

    private FarmingTool(String ... things) {
        this(new Things());
        for (String s : things) {
            this.things.add(s);
        }
    }

    private FarmingTool(Things things) {
        this.things = things;
    }

    @Override
    public final boolean itemMatches(@Nonnull ItemStack item) {
        return Prep.isValid(item) && this.match(item);
    }

    @Nonnull
    public final Things getThings() {
        return this.things;
    }

    protected boolean match(@Nonnull ItemStack item) {
        return this.things.contains(item);
    }

    public static boolean isTool(@Nonnull ItemStack stack) {
        for (FarmingTool type : FarmingTool.values()) {
            if (!type.itemMatches(stack)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static FarmingTool getToolType(@Nonnull ItemStack stack) {
        if (Prep.isValid(stack)) {
            for (FarmingTool type : FarmingTool.values()) {
                if (!type.itemMatches(stack)) continue;
                return type;
            }
        }
        return NONE;
    }

    public static boolean isDryRfTool(@Nonnull ItemStack stack) {
        IEnergyStorage cap = PowerHandlerUtil.getCapability((ICapabilityProvider)stack, null);
        return cap != null && cap.getMaxEnergyStored() > 0 && cap.getEnergyStored() <= 0;
    }

    public static boolean canDamage(@Nonnull ItemStack stack) {
        return stack.func_77984_f() && stack.func_77973_b().func_77645_m();
    }
}

