/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Alloying;
import crazypants.enderio.base.config.recipes.xml.Casting;
import crazypants.enderio.base.config.recipes.xml.Crafting;
import crazypants.enderio.base.config.recipes.xml.Enchanting;
import crazypants.enderio.base.config.recipes.xml.Fermenting;
import crazypants.enderio.base.config.recipes.xml.Sagmilling;
import crazypants.enderio.base.config.recipes.xml.Slicing;
import crazypants.enderio.base.config.recipes.xml.Smelting;
import crazypants.enderio.base.config.recipes.xml.Spawning;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Recipe
extends AbstractConditional {
    private String name;
    private boolean required;
    private boolean disabled;
    @Nonnull
    private final List<AbstractConditional> craftings = new ArrayList<AbstractConditional>();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.disabled) {
            return this;
        }
        try {
            super.readResolve();
            if (this.craftings.isEmpty()) {
                throw new InvalidRecipeConfigException("No recipe elements");
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <recipe> '" + this.getName() + "'");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (this.disabled || !this.active) {
            return;
        }
        try {
            int count = 0;
            for (AbstractConditional crafting : this.craftings) {
                if (this.required) {
                    if (!crafting.isActive()) continue;
                    crafting.enforceValidity();
                    if (!crafting.isValid()) continue;
                    ++count;
                    continue;
                }
                if (!crafting.isActive() || !crafting.isValid()) continue;
                ++count;
            }
            if (count > 1) {
                throw new InvalidRecipeConfigException("Multiple active recipe elements");
            }
            if (count < 1) {
                if (this.required) {
                    throw new InvalidRecipeConfigException("No valid recipe elements");
                }
                this.valid = false;
            } else {
                this.valid = true;
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <recipe> '" + this.getName() + "'");
        }
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (!this.disabled && this.valid && this.active) {
            Log.debug("Registering XML recipe '" + this.getName() + "'");
            for (AbstractConditional crafting : this.craftings) {
                if (!crafting.isValid() || !crafting.isActive()) continue;
                crafting.register(recipeName);
                return;
            }
        } else {
            Log.debug("Skipping XML recipe '" + this.getName() + "' (valid=" + this.valid + ", active=" + this.active + ", required=" + this.required + ", disabled=" + this.disabled + ")");
        }
    }

    @Override
    @Nonnull
    public String getName() {
        if (this.name != null && !this.name.trim().isEmpty()) {
            return this.name.trim();
        }
        return "unnamed recipe";
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("name".equals(name)) {
            this.name = value;
            return true;
        }
        if ("required".equals(name)) {
            this.required = Boolean.parseBoolean(value);
            return true;
        }
        if ("disabled".equals(name)) {
            this.disabled = Boolean.parseBoolean(value);
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        try {
            if ("crafting".equals(name)) {
                this.craftings.add(factory.read(new Crafting(), startElement));
                return true;
            }
            if ("smelting".equals(name)) {
                this.craftings.add(factory.read(new Smelting(), startElement));
                return true;
            }
            if ("casting".equals(name)) {
                this.craftings.add(factory.read(new Casting(), startElement));
                return true;
            }
            if ("enchanting".equals(name)) {
                this.craftings.add(factory.read(new Enchanting(), startElement));
                return true;
            }
            if ("spawning".equals(name)) {
                this.craftings.add(factory.read(new Spawning(), startElement));
                return true;
            }
            if ("alloying".equals(name)) {
                this.craftings.add(factory.read(new Alloying(), startElement));
                return true;
            }
            if ("sagmilling".equals(name)) {
                this.craftings.add(factory.read(new Sagmilling(), startElement));
                return true;
            }
            if ("slicing".equals(name)) {
                this.craftings.add(factory.read(new Slicing(), startElement));
                return true;
            }
            if ("fermenting".equals(name)) {
                this.craftings.add(factory.read(new Fermenting(), startElement));
                return true;
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <recipe> '" + this.getName() + "'");
        }
        return super.setElement(factory, name, startElement);
    }

    @Override
    public boolean isValid() {
        return this.disabled || super.isValid();
    }

    @Override
    public boolean isActive() {
        return !this.disabled && super.isActive();
    }
}

