/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.CapacitorKeyRegistry;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.IndexedScaler;
import crazypants.enderio.base.config.recipes.xml.Scaler;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.util.ResourceLocation;

public class Capacitor
extends AbstractConditional {
    private ResourceLocation key;
    private boolean required;
    private boolean disabled;
    private int base = Integer.MIN_VALUE;
    private Scaler scaler;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        if (this.disabled) {
            return this;
        }
        try {
            super.readResolve();
            if (this.scaler == null) {
                throw new InvalidRecipeConfigException("Missing <scaler> or <indexed>");
            }
            if (this.base == Integer.MIN_VALUE) {
                throw new InvalidRecipeConfigException("'base' is invalid");
            }
            if (this.key != null) {
                this.valid = CapacitorKeyRegistry.contains(this.key);
                if (this.required && !this.valid && this.active) {
                    throw new InvalidRecipeConfigException("'key' is invalid");
                }
            } else {
                throw new InvalidRecipeConfigException("'key' is invalid");
            }
            this.valid |= this.scaler.isValid();
            if (this.required && !this.valid && this.active) {
                throw new InvalidRecipeConfigException("No valid <scaler> or <indexed>");
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <capacitor>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        if (this.disabled || !this.active) {
            return;
        }
        this.scaler.enforceValidity();
        if (this.key == null || !CapacitorKeyRegistry.contains(this.key)) {
            throw new InvalidRecipeConfigException("'key' '" + this.key + "' is invalid");
        }
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (!this.disabled && this.valid && this.active) {
            Log.debug("Registering XML recipe '" + this.getName() + "'");
            CapacitorKeyRegistry.setScaler(this.key, this.scaler.getScaler());
            CapacitorKeyRegistry.setBaseValue(this.key, this.base);
        } else {
            Log.debug("Skipping XML recipe '" + this.getName() + "' (valid=" + this.valid + ", active=" + this.active + ", required=" + this.required + ", disabled=" + this.disabled + ")");
        }
    }

    @Override
    @Nonnull
    public String getName() {
        if (this.key != null) {
            return this.key.toString();
        }
        return "unnamed recipe";
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("key".equals(name)) {
            this.key = new ResourceLocation((String)NullHelper.first((Object[])new String[]{value, ""}));
            return true;
        }
        if ("required".equals(name)) {
            this.required = Boolean.parseBoolean(value);
            return true;
        }
        if ("disabled".equals(name)) {
            this.disabled = Boolean.parseBoolean(value);
            return true;
        }
        if ("base".equals(name)) {
            this.base = Integer.parseInt(value);
            return true;
        }
        if ("scaler".equals(name) && this.scaler == null) {
            this.scaler = new Scaler(value).readResolve();
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("scaler".equals(name) && this.scaler == null) {
            this.scaler = factory.read(new Scaler(), startElement);
            return true;
        }
        if ("indexed".equals(name) && this.scaler == null) {
            this.scaler = factory.read(new IndexedScaler(), startElement);
            return true;
        }
        return super.setElement(factory, name, startElement);
    }

    @Override
    public boolean isValid() {
        return this.disabled || super.isValid();
    }

    @Override
    public boolean isActive() {
        return !this.disabled && super.isActive();
    }
}

