/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.factory;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.factory.IValueFactory;
import crazypants.enderio.base.config.factory.PacketConfigSyncNew;
import crazypants.enderio.base.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

@Mod.EventBusSubscriber(modid="enderio")
public class FactoryManager {
    @Nonnull
    public static final String SERVER_OVERRIDE = " (synced from server)";
    @Nonnull
    public static final String SERVER_SYNC = " (must be kept in sync with server)";
    @Nonnull
    private static final Map<String, IValueFactory> factories = new HashMap<String, IValueFactory>();

    static void read(String mod, String section, ByteBuf buf) {
        Log.debug("Read " + factories.get(mod + "." + section).read(buf) + " config values from server packet for " + mod + " (" + section + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerFactory(@Nonnull IValueFactory factory) {
        Map<String, IValueFactory> map = factories;
        synchronized (map) {
            factories.put(factory.getModid() + "." + factory.getSection(), factory);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggon(PlayerEvent.PlayerLoggedInEvent evt) {
        for (IValueFactory factory : factories.values()) {
            if (!factory.needsSyncing()) continue;
            PacketHandler.sendTo(new PacketConfigSyncNew(factory), (EntityPlayerMP)evt.player);
            Log.debug("Sent config to player " + evt.player.getDisplayNameString() + " for " + factory.getModid() + " (" + factory.getSection() + ")");
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        for (IValueFactory factory : factories.values()) {
            factory.endServerOverride();
            Log.debug("Removed server config override for " + factory.getModid() + " (" + factory.getSection() + ")");
        }
    }
}

