/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.gui;

import com.feed_the_beast.ftblib.lib.EnumTeamColor;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.text.ITextComponent;

public class ClientClaimedChunks {

    public static class ChunkData {
        public static final DataOut.Serializer<ChunkData> SERIALIZER = (data, d) -> data.writeInt(d.flags);
        public static final DataIn.Deserializer<ChunkData> DESERIALIZER = data -> new ChunkData(Team.currentTeam, data.readInt());
        public static final int LOADED = 1;
        public final Team team;
        public final int flags;

        public ChunkData(Team t, int f) {
            this.team = t;
            this.flags = f;
        }

        public int hashCode() {
            return Objects.hash(this.team, this.flags);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o != null && o.getClass() == ChunkData.class) {
                ChunkData d = (ChunkData)o;
                return this.team.equals(d.team) && this.flags == d.flags;
            }
            return false;
        }

        public boolean isLoaded() {
            return Bits.getFlag((int)this.flags, (int)1);
        }
    }

    public static class Team {
        private static Team currentTeam;
        public static final DataOut.Serializer<Team> SERIALIZER;
        public static final DataIn.Deserializer<Team> DESERIALIZER;
        public final String name;
        public EnumTeamColor color;
        public ITextComponent nameComponent;
        public boolean isAlly;
        public final Map<Integer, ChunkData> chunks = new Int2ObjectOpenHashMap();
        public Object shapeProperties;

        public Team(String n) {
            this.name = n;
        }

        static {
            SERIALIZER = (data, team) -> {
                data.writeString(team.name);
                data.writeTextComponent(team.nameComponent);
                data.write((Object)team.color, (DataOut.Serializer)EnumTeamColor.NAME_MAP);
                data.writeBoolean(team.isAlly);
                data.writeMap(team.chunks, DataOut.INT, ChunkData.SERIALIZER);
            };
            DESERIALIZER = data -> {
                Team team = new Team(data.readString());
                team.nameComponent = data.readTextComponent();
                team.color = (EnumTeamColor)data.read((DataIn.Deserializer)EnumTeamColor.NAME_MAP);
                team.isAlly = data.readBoolean();
                currentTeam = team;
                data.readMap(team.chunks, DataIn.INT, ChunkData.DESERIALIZER);
                return team;
            };
        }
    }
}

