/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.features;

import com.google.common.math.StatsAccumulator;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.world.feature.TFGenerator;

public class GenDruidHut
extends TFGenerator {
    private static final ResourceLocation STRUCTURE = new ResourceLocation("twilightforest", "landscape/druid_hut");

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int dz;
        BlockPos transformedSize;
        int dx;
        MinecraftServer minecraftserver = world.func_73046_m();
        TemplateManager templatemanager = world.func_72860_G().func_186340_h();
        Template template = templatemanager.func_186237_a(minecraftserver, STRUCTURE);
        Random random = world.func_175726_f(pos).func_76617_a(987234911L);
        Rotation[] rotations = Rotation.values();
        Rotation rotation = rotations[random.nextInt(rotations.length)];
        Mirror[] mirrors = Mirror.values();
        Mirror mirror = mirrors[random.nextInt(mirrors.length + 1) % mirrors.length];
        ChunkPos chunkpos = new ChunkPos(pos.func_177982_a(-8, 0, -8));
        StructureBoundingBox structureboundingbox = new StructureBoundingBox(chunkpos.func_180334_c() + 8, 0, chunkpos.func_180333_d() + 8, chunkpos.func_180332_e() + 8, 255, chunkpos.func_180330_f() + 8);
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation).func_186223_a(structureboundingbox).func_189950_a(random);
        BlockPos posSnap = chunkpos.func_180331_a(8, pos.func_177956_o() - 1, 8);
        BlockPos.MutableBlockPos startPos = new BlockPos.MutableBlockPos(posSnap.func_177982_a(dx = random.nextInt(17 - (transformedSize = template.func_186257_a(rotation)).func_177958_n()), 0, dz = random.nextInt(17 - transformedSize.func_177952_p())));
        if (!GenDruidHut.offsetToAverageGroundLevel(world, startPos, transformedSize)) {
            return false;
        }
        BlockPos placementPos = template.func_189961_a((BlockPos)startPos, mirror, rotation);
        template.func_189962_a(world, placementPos, placementsettings, 20);
        return true;
    }

    private static boolean offsetToAverageGroundLevel(World world, BlockPos.MutableBlockPos startPos, BlockPos size) {
        StatsAccumulator heights = new StatsAccumulator();
        for (int dx = 0; dx < size.func_177958_n(); ++dx) {
            for (int dz = 0; dz < size.func_177952_p(); ++dz) {
                int y;
                int x = startPos.func_177958_n() + dx;
                int z = startPos.func_177952_p() + dz;
                for (y = world.func_189649_b(x, z); y >= 0; --y) {
                    IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
                    if (GenDruidHut.isBlockNotOk(state)) {
                        return false;
                    }
                    if (GenDruidHut.isBlockOk(state)) break;
                }
                if (y < 0) {
                    return false;
                }
                heights.add((double)y);
            }
        }
        if (heights.populationStandardDeviation() > 2.0) {
            return false;
        }
        int baseY = (int)Math.round(heights.mean());
        int maxY = (int)heights.max();
        startPos.func_185336_p(baseY);
        return GenDruidHut.isAreaClear((IBlockAccess)world, startPos.func_177981_b(maxY - baseY + 1), startPos.func_177971_a((Vec3i)size));
    }

    private static boolean isAreaClear(IBlockAccess world, BlockPos min, BlockPos max) {
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)min, (BlockPos)max)) {
            if (world.func_180495_p(pos).func_177230_c().func_176200_f(world, pos)) continue;
            return false;
        }
        return true;
    }

    private static boolean isBlockOk(IBlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151578_c || material == Material.field_151577_b || material == Material.field_151595_p;
    }

    private static boolean isBlockNotOk(IBlockState state) {
        Material material = state.func_185904_a();
        return material == Material.field_151586_h || material == Material.field_151587_i || state.func_177230_c() == Blocks.field_150357_h;
    }
}

