/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile;

import com.buuz135.industrial.item.addon.EnergyFieldAddon;
import com.buuz135.industrial.item.addon.movility.TransferAddon;
import com.buuz135.industrial.jei.JEIHelper;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.api.IAcceptsTransferAddons;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.tile.block.EnergyFieldProviderBlock;
import com.buuz135.industrial.tile.world.EnergyFieldProviderTile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.ndrei.teslacorelib.compatibility.FontRendererUtil;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.SideDrawerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.items.SpeedUpgradeTier1;
import net.ndrei.teslacorelib.items.SpeedUpgradeTier2;
import net.ndrei.teslacorelib.tileentities.ElectricMachine;
import org.jetbrains.annotations.NotNull;

public abstract class CustomElectricMachine
extends ElectricMachine
implements IAcceptsTransferAddons {
    protected CustomElectricMachine(int typeId) {
        super(typeId);
    }

    protected void initializeInventories() {
        super.initializeInventories();
        ArrayList<EnumFacing> facings = new ArrayList<EnumFacing>();
        facings.addAll(Arrays.asList(EnumFacing.values()));
        Arrays.stream(EnumDyeColor.values()).forEach(enumDyeColor -> this.getSideConfig().setSidesForColor(enumDyeColor, facings));
    }

    protected int getEnergyForWork() {
        return this.func_145838_q() instanceof CustomOrientedBlock ? ((CustomOrientedBlock)this.func_145838_q()).getEnergyForWork() : Integer.MAX_VALUE;
    }

    protected int getEnergyForWorkRate() {
        return this.func_145838_q() instanceof CustomOrientedBlock ? ((CustomOrientedBlock)this.func_145838_q()).getEnergyRate() : Integer.MAX_VALUE;
    }

    protected long getEnergyInputRate() {
        return 4000L;
    }

    public int speedUpgradeLevel() {
        if (this.hasAddon(SpeedUpgradeTier2.class)) {
            return 2;
        }
        if (this.hasAddon(SpeedUpgradeTier1.class)) {
            return 1;
        }
        return 0;
    }

    protected int getMinimumWorkTicks() {
        return 4;
    }

    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(final BasicTeslaGuiContainer<?> container) {
        List pieces = super.getGuiContainerPieces(container);
        if (JEIHelper.isInstalled()) {
            pieces.add(new SideDrawerPiece(1){

                protected void renderState(BasicTeslaGuiContainer<?> basicTeslaGuiContainer, int i, BoundingRectangle boundingRectangle) {
                    container.bindDefaultTexture();
                    FontRendererUtil.INSTANCE.getFontRenderer().func_78276_b("J", boundingRectangle.getLeft() + 6, boundingRectangle.getTop() + 4, 4210751);
                }

                protected void clicked() {
                    JEIHelper.openBlockUses(new ItemStack(CustomElectricMachine.this.func_145838_q()));
                }
            });
        }
        return pieces;
    }

    public void protectedUpdate() {
        ItemStack addon;
        super.protectedUpdate();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 2L == 0L && this.hasAddon(EnergyFieldAddon.class) && (addon = this.getAddonStack(EnergyFieldAddon.class)).hasCapability(CapabilityEnergy.ENERGY, null)) {
            EnergyFieldProviderTile tile;
            IEnergyStorage storage = (IEnergyStorage)addon.getCapability(CapabilityEnergy.ENERGY, null);
            storage.extractEnergy((int)this.getEnergyStorage().givePower((long)storage.extractEnergy(512, true)), false);
            BlockPos pos = ItemRegistry.energyFieldAddon.getLinkedBlockPos(addon);
            if (this.field_145850_b.func_180495_p(pos).func_177230_c() instanceof EnergyFieldProviderBlock && this.field_145850_b.func_175707_a(pos, pos) && (tile = (EnergyFieldProviderTile)this.field_145850_b.func_175625_s(pos)).getWorkingArea().func_186662_g(1.0).func_72318_a(new Vec3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()))) {
                float pull = tile.consumeWorkEnergy(Math.min(storage.getMaxEnergyStored() - storage.getEnergyStored(), 1000));
                storage.receiveEnergy((int)pull, false);
            }
            this.forceSync();
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L && this.getAddonItems() != null) {
            this.workTransferAddon((TileEntity)this, this.getAddonItems());
        }
    }

    public boolean canAcceptEnergyFieldAddon() {
        return !this.hasAddon(EnergyFieldAddon.class);
    }

    @Override
    public boolean canAcceptAddon(TransferAddon addon) {
        return !this.hasAddon(addon.getClass()) || this.getAddon(addon.getClass()) != null && ((TransferAddon)this.getAddon(addon.getClass())).getMode() != addon.getMode();
    }
}

