/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeStringLPElement;

public abstract class ValueTypeBase<V extends IValue>
implements IValueType<V> {
    private final String typeName;
    private final int color;
    private final String colorFormat;
    private String unlocalizedName = null;

    public ValueTypeBase(String typeName, int color, String colorFormat) {
        this.typeName = typeName;
        this.color = color;
        this.colorFormat = colorFormat;
        if (MinecraftHelpers.isModdedEnvironment() && MinecraftHelpers.isClientSide()) {
            this.registerModelResourceLocation();
        }
    }

    @Override
    public boolean isCategory() {
        return false;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    protected String getUnlocalizedPrefix() {
        return "valuetype.valuetypes." + this.getModId() + this.getTypeNamespace() + this.getTypeName();
    }

    protected String getTypeNamespace() {
        return ".";
    }

    @Override
    public String getUnlocalizedName() {
        return this.unlocalizedName != null ? this.unlocalizedName : (this.unlocalizedName = this.getUnlocalizedPrefix() + ".name");
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public int getDisplayColor() {
        return this.color;
    }

    @Override
    public String getDisplayColorFormat() {
        return this.colorFormat;
    }

    @Override
    public boolean correspondsTo(IValueType<?> valueType) {
        return this == valueType;
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModelResourceLocation() {
        ValueTypes.REGISTRY.registerValueTypeModel(this, new ResourceLocation(this.getModId() + ":valuetype" + this.getTypeNamespace().replace('.', '/') + this.getTypeName().replace('.', '/')));
    }

    @Override
    public void loadTooltip(List<String> lines, boolean appendOptionalInfo, @Nullable V value) {
        String typeName = L10NHelpers.localize((String)this.getUnlocalizedName(), (Object[])new Object[0]);
        lines.add(L10NHelpers.localize((String)"valuetype.integrateddynamics.tooltip.type_name", (Object[])new Object[]{this.getDisplayColorFormat() + typeName}));
        if (appendOptionalInfo) {
            L10NHelpers.addOptionalInfo(lines, (String)this.getUnlocalizedPrefix());
        }
    }

    @Override
    public L10NHelpers.UnlocalizedString canDeserialize(String value) {
        try {
            this.deserialize(value);
            return null;
        }
        catch (IllegalArgumentException e) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_input", new Object[]{value});
        }
    }

    @Override
    public V materialize(V value) throws EvaluationException {
        return value;
    }

    public String toString() {
        return L10NHelpers.localize((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeStringLPElement((IValueType)this);
    }

    protected String getModId() {
        return "integrateddynamics";
    }
}

