/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.valuetype;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.EnumFacing;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.client.render.valuetype.IValueTypeWorldRenderer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;

public class TextValueTypeWorldRenderer
implements IValueTypeWorldRenderer {
    private static final float MAX = 12.5f;
    private static final float MARGIN_FACTOR = 1.1f;

    @Override
    public void renderValue(IPartContainer partContainer, double x, double y, double z, float partialTick, int destroyStage, EnumFacing direction, IPartType partType, IValue value, TileEntityRendererDispatcher rendererDispatcher, float distanceAlpha) {
        String[] lines;
        FontRenderer fontRenderer = rendererDispatcher.func_147548_a();
        float maxWidth = 0.0f;
        for (String line : lines = value.getType().toCompactString(value).split("(?<=[^\\\\])\\\\n")) {
            float width = fontRenderer.func_78256_a(this.polishLine(line)) - 1;
            maxWidth = Math.max(maxWidth, width);
        }
        float singleHeight = fontRenderer.field_78288_b;
        float totalHeight = singleHeight * (float)lines.length;
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        float scaleX = 12.5f / (maxWidth * 1.1f);
        float scaleY = 12.5f / (totalHeight * 1.1f);
        float scale = Math.min(scaleX, scaleY);
        float newWidth = maxWidth * scale;
        float newHeight = totalHeight * scale;
        GlStateManager.func_179109_b((float)((12.5f - newWidth) / 2.0f), (float)((12.5f - newHeight) / 2.0f), (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int offset = 0;
        for (String line : lines) {
            int color = Helpers.addAlphaToColor((int)value.getType().getDisplayColor(), (float)distanceAlpha);
            rendererDispatcher.func_147548_a().func_78276_b(this.polishLine(line), 0, offset, color);
            offset = (int)((float)offset + singleHeight);
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    protected String polishLine(String line) {
        return line.replaceAll("\\\\\\\\n", "\\\\n");
    }
}

