/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.block.BlockPneumaticDoor;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticDoor;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityPneumaticDoorBase
extends TileEntityPneumaticBase
implements IRedstoneControl,
IMinWorkingPressure,
ICamouflageableTE {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.pneumaticDoor.button.playerNearby", (Object)"gui.tab.redstoneBehaviour.pneumaticDoor.button.playerNearbyAndLooking", (Object)"gui.tab.redstoneBehaviour.pneumaticDoor.button.woodenDoor");
    public static final int INVENTORY_SIZE = 1;
    private TileEntityPneumaticDoor door;
    private TileEntityPneumaticDoorBase doubleDoor;
    @DescSynced
    private boolean rightGoing;
    @DescSynced
    @LazySynced
    public float progress;
    @DescSynced
    private boolean opening;
    public boolean wasPowered;
    @DescSynced
    private ItemStack camoStack = ItemStack.field_190927_a;
    private IBlockState camoState;
    @GuiSynced
    public int redstoneMode;

    public TileEntityPneumaticDoorBase() {
        super(5.0f, 7.0f, 2000, 4);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED, IItemRegistry.EnumUpgrade.RANGE);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        float oldProgress = this.progress;
        if (!this.func_145831_w().field_72995_K) {
            if (this.getPressure() >= 2.0f) {
                if ((this.func_145831_w().func_82737_E() & 0x3FL) == 0L) {
                    TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a(this.getRotation(), 3));
                    this.doubleDoor = te instanceof TileEntityPneumaticDoorBase ? (TileEntityPneumaticDoorBase)te : null;
                }
                this.setOpening(this.shouldOpen() || this.isNeighborOpening());
                this.setNeighborOpening(this.isOpening());
            } else {
                this.setOpening(true);
            }
        }
        float targetProgress = this.opening ? 1.0f : 0.0f;
        float speedMultiplier = this.getSpeedMultiplierFromUpgrades();
        if (this.progress < targetProgress) {
            this.progress = this.progress < targetProgress - 0.2f ? (this.progress += 0.04f * speedMultiplier) : (this.progress += 0.01f * speedMultiplier);
            if (this.progress > targetProgress) {
                this.progress = targetProgress;
            }
        }
        if (this.progress > targetProgress) {
            this.progress = this.progress > targetProgress + 0.2f ? (this.progress -= 0.04f * speedMultiplier) : (this.progress -= 0.01f * speedMultiplier);
            if (this.progress < targetProgress) {
                this.progress = targetProgress;
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.addAir((int)(-Math.abs(oldProgress - this.progress) * 300.0f * (this.getSpeedUsageMultiplierFromUpgrades() / speedMultiplier)));
        }
        this.door = this.getDoor();
        if (this.door != null) {
            this.door.setRotationAngle(this.progress * 90.0f);
            if (!this.func_145831_w().field_72995_K) {
                this.rightGoing = this.door.rightGoing;
            }
        }
    }

    private boolean shouldOpen() {
        switch (this.redstoneMode) {
            case 0: 
            case 1: {
                int range = 2 + this.getUpgrades(IItemRegistry.EnumUpgrade.RANGE);
                AxisAlignedBB aabb = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - range), (double)(this.func_174877_v().func_177956_o() - range), (double)(this.func_174877_v().func_177952_p() - range), (double)(this.func_174877_v().func_177958_n() + range + 1), (double)(this.func_174877_v().func_177956_o() + range + 1), (double)(this.func_174877_v().func_177952_p() + range + 1));
                List players = this.func_145831_w().func_72872_a(EntityPlayer.class, aabb);
                for (EntityPlayer player : players) {
                    if (PneumaticCraftUtils.getProtectingSecurityStations(this.func_145831_w(), this.func_174877_v(), player, false, false) != 0) continue;
                    if (this.redstoneMode == 0) {
                        return true;
                    }
                    ((BlockPneumaticDoor)Blockss.PNEUMATIC_DOOR).isTrackingPlayerEye = true;
                    BlockPos lookedPosition = PneumaticCraftUtils.getEntityLookedBlock((EntityLivingBase)player, (float)range * 1.41f);
                    ((BlockPneumaticDoor)Blockss.PNEUMATIC_DOOR).isTrackingPlayerEye = false;
                    if (lookedPosition == null) continue;
                    if (lookedPosition.equals((Object)new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()))) {
                        return true;
                    }
                    if (this.door == null) continue;
                    if (lookedPosition.equals((Object)new BlockPos(this.door.func_174877_v().func_177958_n(), this.door.func_174877_v().func_177956_o(), this.door.func_174877_v().func_177952_p()))) {
                        return true;
                    }
                    if (!lookedPosition.equals((Object)new BlockPos(this.door.func_174877_v().func_177958_n(), this.door.func_174877_v().func_177956_o() + (this.door.isTopDoor() ? -1 : 1), this.door.func_174877_v().func_177952_p()))) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                return this.opening;
            }
        }
        return false;
    }

    public void setOpening(boolean opening) {
        boolean wasOpening = this.opening;
        this.opening = opening;
        if (this.opening != wasOpening) {
            NetworkHandler.sendToAllAround(new PacketPlaySound(Sounds.PNEUMATIC_DOOR, SoundCategory.BLOCKS, this.func_174877_v(), 1.0f, 1.0f, false), this.func_145831_w());
            this.sendDescriptionPacket();
        }
    }

    public boolean isOpening() {
        return this.opening;
    }

    private boolean isNeighborOpening() {
        return this.doubleDoor != null && this.doubleDoor.shouldOpen();
    }

    public void setNeighborOpening(boolean opening) {
        if (this.doubleDoor != null && this.doubleDoor.getPressure() >= 2.0f) {
            this.doubleDoor.setOpening(opening);
        }
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side != EnumFacing.UP;
    }

    private TileEntityPneumaticDoor getDoor() {
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.getRotation()).func_177982_a(0, -1, 0));
        if (te instanceof TileEntityPneumaticDoor) {
            TileEntityPneumaticDoor teDoor = (TileEntityPneumaticDoor)te;
            if (this.getRotation().func_176746_e() == teDoor.getRotation() && !teDoor.rightGoing) {
                return (TileEntityPneumaticDoor)te;
            }
            if (this.getRotation().func_176735_f() == teDoor.getRotation() && teDoor.rightGoing) {
                return (TileEntityPneumaticDoor)te;
            }
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.progress = tag.func_74760_g("extension");
        this.opening = tag.func_74767_n("opening");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.rightGoing = tag.func_74767_n("rightGoing");
        this.camoStack = ICamouflageableTE.readCamoStackFromNBT(tag);
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74776_a("extension", this.progress);
        tag.func_74757_a("opening", this.opening);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74757_a("rightGoing", this.rightGoing);
        ICamouflageableTE.writeCamoStackToNBT(this.camoStack, tag);
        return tag;
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public String getName() {
        return Blockss.PNEUMATIC_DOOR_BASE.func_149739_a();
    }

    @Override
    public float getMinWorkingPressure() {
        return 2.0f;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public IBlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(IBlockState state) {
        this.camoState = state;
        this.camoStack = ICamouflageableTE.getStackForState(state);
        this.sendDescriptionPacket();
        this.func_70296_d();
    }

    @Override
    public void onDescUpdate() {
        this.camoState = ICamouflageableTE.getStateForStack(this.camoStack);
        this.rerenderTileEntity();
    }

    @Override
    public String getRedstoneTabTitle() {
        return "gui.tab.redstoneBehaviour.pneumaticDoor.openWhen";
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }
}

