/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.block.tubes.IPneumaticPosProvider;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaConstant;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethod;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityPneumaticBase
extends TileEntityTickableBase
implements IPneumaticPosProvider {
    @GuiSynced
    final IAirHandler airHandler;
    public final float dangerPressure;
    public final float criticalPressure;
    private final int defaultVolume;

    public TileEntityPneumaticBase(float dangerPressure, float criticalPressure, int volume, int upgradeSlots) {
        super(upgradeSlots);
        this.airHandler = PneumaticRegistry.getInstance().getAirHandlerSupplier().createAirHandler(dangerPressure, criticalPressure, volume);
        for (Item upgrade : this.airHandler.getApplicableUpgrades()) {
            this.addApplicableUpgrade(upgrade);
        }
        this.dangerPressure = dangerPressure;
        this.criticalPressure = criticalPressure;
        this.defaultVolume = volume;
        this.addLuaMethods();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.airHandler.update();
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.airHandler.validate(this);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.airHandler.writeToNBT(tag);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.airHandler.readFromNBT(tag);
    }

    @Override
    public void onNeighborTileUpdate() {
        super.onNeighborTileUpdate();
        this.airHandler.onNeighborChange();
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.airHandler.onNeighborChange();
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        super.writeToPacket(tag);
        this.airHandler.writeToNBT(tag);
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
        super.readFromPacket(tag);
        this.airHandler.readFromNBT(tag);
    }

    @Override
    protected void addLuaMethods() {
        super.addLuaMethods();
        this.luaMethods.add(new LuaMethod("getPressure"){

            @Override
            public Object[] call(Object[] args) throws Exception {
                if (args.length == 0) {
                    return new Object[]{Float.valueOf(TileEntityPneumaticBase.this.airHandler.getPressure())};
                }
                if (args.length == 1) {
                    IAirHandler handler = TileEntityPneumaticBase.this.getAirHandler(this.getDirForString((String)args[0]));
                    return new Object[]{Float.valueOf(handler != null ? handler.getPressure() : 0.0f)};
                }
                throw new IllegalArgumentException("getPressure method requires 0 or 1 argument (direction: up, down, east, west, north, south)!");
            }
        });
        this.luaMethods.add(new LuaConstant("getDangerPressure", this.dangerPressure));
        this.luaMethods.add(new LuaConstant("getCriticalPressure", this.criticalPressure));
        this.luaMethods.add(new LuaConstant("getDefaultVolume", this.defaultVolume));
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos pos() {
        return this.func_174877_v();
    }

    @Override
    public IAirHandler getAirHandler(EnumFacing side) {
        return side == null || this.isConnectedTo(side) ? this.airHandler : null;
    }

    public float getPressure() {
        return this.getAirHandler(null).getPressure();
    }

    public void addAir(int air) {
        this.getAirHandler(null).addAir(air);
    }

    public boolean isConnectedTo(EnumFacing side) {
        return true;
    }

    public int getDefaultVolume() {
        return this.defaultVolume;
    }
}

