/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.List;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityOmnidirectionalHopper
extends TileEntityTickableBase
implements IRedstoneControlled,
IComparatorSupport {
    public static final int INVENTORY_SIZE = 5;
    @DescSynced
    EnumFacing inputDir = EnumFacing.UP;
    @DescSynced
    private EnumFacing outputDir = EnumFacing.UP;
    private final ComparatorItemStackHandler inventory = new ComparatorItemStackHandler(this, this.getInvSize());
    private int lastComparatorValue = -1;
    @GuiSynced
    public int redstoneMode;
    private int cooldown;
    @GuiSynced
    boolean leaveMaterial;
    private int importSlot = 0;

    public TileEntityOmnidirectionalHopper() {
        this(4);
    }

    public TileEntityOmnidirectionalHopper(int upgradeSlots) {
        super(upgradeSlots);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED);
    }

    protected int getInvSize() {
        return 5;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && --this.cooldown <= 0 && this.redstoneAllows()) {
            int maxItems = this.getMaxItems();
            boolean success = this.doImport(maxItems);
            int n = this.cooldown = (success |= this.doExport(maxItems)) ? this.getItemTransferInterval() : 8;
            if (this.lastComparatorValue != this.getComparatorValueInternal()) {
                this.lastComparatorValue = this.getComparatorValueInternal();
                this.updateNeighbours();
            }
        }
    }

    protected int getComparatorValueInternal() {
        return this.inventory.getComparatorValue();
    }

    protected boolean doExport(int maxItems) {
        EnumFacing dir = this.getRotation();
        TileEntity neighbor = this.getCachedNeighbor(dir);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || this.leaveMaterial && stack.func_190916_E() <= 1) continue;
            ItemStack exportedStack = stack.func_77946_l();
            if (this.leaveMaterial) {
                exportedStack.func_190918_g(1);
            }
            if (exportedStack.func_190916_E() > maxItems) {
                exportedStack.func_190920_e(maxItems);
            }
            int count = exportedStack.func_190916_E();
            ItemStack remainder = IOHelper.insert(neighbor, exportedStack, dir.func_176734_d(), false);
            int exportedItems = count - remainder.func_190916_E();
            stack.func_190918_g(exportedItems);
            if (exportedItems > 0) {
                this.inventory.invalidateComparatorValue();
            }
            if ((maxItems -= exportedItems) > 0) continue;
            return true;
        }
        return false;
    }

    protected boolean doImport(int maxItems) {
        boolean success = false;
        IItemHandler handler = IOHelper.getInventoryForTE(this.getCachedNeighbor(this.inputDir), this.inputDir.func_176734_d());
        if (handler != null) {
            if (this.importSlot >= handler.getSlots()) {
                this.importSlot = 0;
            }
            for (int i = 0; i < maxItems; ++i) {
                IOHelper.LocatedItemStack extracted = IOHelper.extractOneItem(handler, this.importSlot, true);
                if (extracted.stack.func_190926_b()) break;
                ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)extracted.stack, (boolean)false);
                if (!excess.func_190926_b()) {
                    if (++this.importSlot < handler.getSlots()) break;
                    this.importSlot = 0;
                    break;
                }
                handler.extractItem(extracted.slot, 1, false);
                this.importSlot = extracted.slot;
                success = true;
            }
        }
        for (EntityItem entity : TileEntityOmnidirectionalHopper.getNeighborItems(this, this.inputDir)) {
            ItemStack remainder = IOHelper.insert(this, entity.func_92059_d(), null, false);
            if (remainder.func_190926_b()) {
                entity.func_70106_y();
                success = true;
                continue;
            }
            if (remainder.func_190916_E() >= entity.func_92059_d().func_190916_E()) continue;
            entity.func_92058_a(remainder);
            success = true;
        }
        return success;
    }

    static List<EntityItem> getNeighborItems(TileEntity te, EnumFacing dir) {
        AxisAlignedBB box = new AxisAlignedBB(te.func_174877_v().func_177972_a(dir));
        return te.func_145831_w().func_175647_a(EntityItem.class, box, EntitySelectors.field_94557_a);
    }

    public int getMaxItems() {
        int upgrades = this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED);
        if (upgrades > 3) {
            return Math.min(1 << upgrades - 3, 256);
        }
        return 1;
    }

    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED));
    }

    public void setInputDirection(EnumFacing dir) {
        this.inputDir = dir;
    }

    public EnumFacing getInputDirection() {
        return this.inputDir;
    }

    @Override
    public EnumFacing getRotation() {
        return this.outputDir;
    }

    public void setRotation(EnumFacing rotation) {
        this.outputDir = rotation;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("inputDir", this.inputDir.ordinal());
        tag.func_74768_a("outputDir", this.outputDir.ordinal());
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74757_a("leaveMaterial", this.leaveMaterial);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inputDir = EnumFacing.func_82600_a((int)tag.func_74762_e("inputDir"));
        this.outputDir = EnumFacing.func_82600_a((int)tag.func_74762_e("outputDir"));
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.leaveMaterial = tag.func_74767_n("leaveMaterial");
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public String getName() {
        return Blockss.OMNIDIRECTIONAL_HOPPER.func_149739_a();
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        } else if (buttonID == 1) {
            this.leaveMaterial = false;
        } else if (buttonID == 2) {
            this.leaveMaterial = true;
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public boolean doesLeaveMaterial() {
        return this.leaveMaterial;
    }

    @Override
    public int getComparatorValue() {
        return this.getComparatorValueInternal();
    }
}

