/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.minigun;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.client.render.RenderProgressingLine;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class Minigun {
    public static final double MAX_GUN_SPEED = 0.4;
    private static final double RAYTRACE_RANGE = 50.0;
    private static final double MAX_GUN_YAW_CHANGE = 10.0;
    private static final double MAX_GUN_PITCH_CHANGE = 10.0;
    private final boolean requiresTarget;
    private double minigunSpeed;
    private int minigunTriggerTimeOut;
    private int minigunSoundCounter = -1;
    private final Random rand = new Random();
    private double minigunRotation;
    private double oldMinigunRotation;
    public double minigunYaw;
    public double oldMinigunYaw;
    public double minigunPitch;
    public double oldMinigunPitch;
    private final RenderProgressingLine minigunFire = new RenderProgressingLine().setProgress(1.0f);
    private boolean sweeping;
    private double sweepingProgress;
    private boolean gunAimedAtTarget;
    private IPressurizable pressurizable;
    private int airUsage;
    protected ItemStack stack = ItemStack.field_190927_a;
    protected ItemStack ammo = ItemStack.field_190927_a;
    protected EntityPlayer player;
    protected World world;
    private EntityLivingBase attackTarget;

    public Minigun(boolean requiresTarget) {
        this.requiresTarget = requiresTarget;
    }

    public Minigun setPressurizable(IPressurizable pressurizable, int airUsage) {
        this.pressurizable = pressurizable;
        this.airUsage = airUsage;
        return this;
    }

    public Minigun setItemStack(@Nonnull ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public Minigun setAmmo(@Nonnull ItemStack ammo) {
        this.ammo = ammo;
        return this;
    }

    public Minigun setPlayer(EntityPlayer player) {
        this.player = player;
        return this;
    }

    public Minigun setWorld(World world) {
        this.world = world;
        return this;
    }

    public Minigun setAttackTarget(EntityLivingBase entity) {
        this.attackTarget = entity;
        return this;
    }

    public abstract boolean isMinigunActivated();

    public abstract void setMinigunActivated(boolean var1);

    public abstract void setAmmoColorStack(@Nonnull ItemStack var1);

    public abstract int getAmmoColor();

    public abstract void playSound(SoundEvent var1, float var2, float var3);

    protected int getAmmoColor(@Nonnull ItemStack stack) {
        return stack.func_190926_b() ? -13553359 : Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 1);
    }

    public Object getSoundSource() {
        return this.player;
    }

    public double getMinigunSpeed() {
        return this.minigunSpeed;
    }

    public void setMinigunSpeed(double minigunSpeed) {
        this.minigunSpeed = minigunSpeed;
    }

    public int getMinigunTriggerTimeOut() {
        return this.minigunTriggerTimeOut;
    }

    public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
        this.minigunTriggerTimeOut = minigunTriggerTimeOut;
    }

    public int getMinigunSoundCounter() {
        return this.minigunSoundCounter;
    }

    public void setMinigunSoundCounter(int minigunSoundCounter) {
        this.minigunSoundCounter = minigunSoundCounter;
    }

    public double getMinigunRotation() {
        return this.minigunRotation;
    }

    public void setMinigunRotation(double minigunRotation) {
        this.minigunRotation = minigunRotation;
    }

    public double getOldMinigunRotation() {
        return this.oldMinigunRotation;
    }

    public void setOldMinigunRotation(double oldMinigunRotation) {
        this.oldMinigunRotation = oldMinigunRotation;
    }

    public EntityLivingBase getAttackTarget() {
        return this.attackTarget;
    }

    public void setSweeping(boolean sweeping) {
        this.sweeping = sweeping;
    }

    public boolean isSweeping() {
        return this.sweeping;
    }

    public boolean tryFireMinigun(EntityLivingBase target) {
        boolean lastShotOfAmmo = false;
        if (!this.ammo.func_190926_b() && (this.pressurizable == null || this.pressurizable.getPressure(this.stack) > 0.0f)) {
            this.setMinigunTriggerTimeOut(Math.max(10, this.getMinigunSoundCounter()));
            if (this.getMinigunSpeed() == 0.4 && (!this.requiresTarget || this.gunAimedAtTarget)) {
                ItemStack potion;
                RayTraceResult rtr = null;
                if (!this.requiresTarget) {
                    rtr = this.raytraceTarget();
                    target = rtr.field_72308_g instanceof EntityLivingBase ? (EntityLivingBase)rtr.field_72308_g : null;
                }
                int ammoCost = 1;
                if (this.pressurizable != null) {
                    this.pressurizable.addAir(this.stack, -this.airUsage);
                }
                if (target != null) {
                    ItemStack potion2 = ItemGunAmmo.getPotion(this.ammo);
                    if (!potion2.func_190926_b()) {
                        if (this.rand.nextInt(ConfigHandler.general.minigunPotionProcChance) == 0) {
                            if (potion2.func_77973_b() == Items.field_151068_bn) {
                                List effects = PotionUtils.func_185189_a((ItemStack)potion2);
                                for (PotionEffect effect : effects) {
                                    target.func_70690_d(new PotionEffect(effect));
                                }
                            } else if (potion2.func_77973_b() == Items.field_185155_bH || potion2.func_77973_b() == Items.field_185156_bI) {
                                EntityPotion entityPotion = new EntityPotion(this.world, (EntityLivingBase)this.player, potion2);
                                entityPotion.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                                this.world.func_72838_d((Entity)entityPotion);
                            }
                        }
                    } else {
                        target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.player), ConfigHandler.general.configMinigunDamage);
                    }
                } else if (rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK && ((potion = ItemGunAmmo.getPotion(this.ammo)).func_77973_b() == Items.field_185155_bH || potion.func_77973_b() == Items.field_185156_bI)) {
                    int n = ammoCost = potion.func_77973_b() == Items.field_185155_bH ? 3 : 6;
                    if (this.rand.nextInt(ConfigHandler.general.minigunPotionProcChance) == 0) {
                        EntityPotion entityPotion = new EntityPotion(this.world, (EntityLivingBase)this.player, potion);
                        BlockPos pos = rtr.func_178782_a();
                        entityPotion.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                        this.world.func_72838_d((Entity)entityPotion);
                    }
                }
                lastShotOfAmmo = this.ammo.func_96631_a(ammoCost, this.rand, this.player instanceof EntityPlayerMP ? (EntityPlayerMP)this.player : null);
            }
        }
        return lastShotOfAmmo;
    }

    private RayTraceResult raytraceTarget() {
        RayTraceResult mop = PneumaticCraftUtils.getMouseOverServer((EntityLivingBase)this.player, 50.0);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && this.world instanceof WorldServer) {
            BlockPos pos = mop.func_178782_a();
            double x = pos.func_177958_n() + mop.field_178784_b.func_82601_c();
            double y = pos.func_177956_o() + mop.field_178784_b.func_96559_d();
            double z = pos.func_177952_p() + mop.field_178784_b.func_82599_e();
            IBlockState state = this.world.func_180495_p(pos);
            ((WorldServer)this.world).func_175739_a(EnumParticleTypes.BLOCK_DUST, x, y, z, 25, 0.0, 0.5, 0.0, 0.15, new int[]{Block.func_176210_f((IBlockState)state)});
        }
        return mop;
    }

    public void update(double posX, double posY, double posZ) {
        this.setOldMinigunRotation(this.getMinigunRotation());
        this.oldMinigunYaw = this.minigunYaw;
        this.oldMinigunPitch = this.minigunPitch;
        if (this.attackTarget != null && this.attackTarget.field_70128_L) {
            this.attackTarget = null;
        }
        if (!this.world.field_72995_K) {
            this.setMinigunActivated(this.getMinigunTriggerTimeOut() > 0);
            this.setAmmoColorStack(this.ammo);
            if (this.getMinigunTriggerTimeOut() > 0) {
                this.setMinigunTriggerTimeOut(this.getMinigunTriggerTimeOut() - 1);
                if (this.getMinigunSpeed() == 0.0) {
                    this.playSound(Sounds.HUD_INIT, 3.0f, 0.9f);
                }
            }
            if (this.getMinigunSoundCounter() == 0 && this.getMinigunTriggerTimeOut() == 0) {
                this.playSound(Sounds.MINIGUN_STOP, 3.0f, 0.5f);
                this.setMinigunSoundCounter(-1);
            }
        }
        if (this.isMinigunActivated()) {
            double lastSpeed = this.getMinigunSpeed();
            this.setMinigunSpeed(Math.min(this.getMinigunSpeed() + 0.01, 0.4));
            if (this.getMinigunSpeed() > lastSpeed && this.getMinigunSpeed() >= 0.4 && !this.world.field_72995_K) {
                NetworkHandler.sendToDimension(new PacketPlayMovingSound(MovingSounds.Sound.MINIGUN, this.getSoundSource()), this.world.field_73011_w.getDimension());
            }
        } else {
            this.setMinigunSpeed(Math.max(0.0, this.getMinigunSpeed() - 0.003));
        }
        this.setMinigunRotation(this.getMinigunRotation() + this.getMinigunSpeed());
        double targetPitch = 0.0;
        if (this.attackTarget != null) {
            double deltaX = posX - this.attackTarget.field_70165_t;
            double deltaZ = posZ - this.attackTarget.field_70161_v;
            double targetYaw = deltaX >= 0.0 && deltaZ < 0.0 ? Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0 : (deltaX >= 0.0 && deltaZ >= 0.0 ? Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0 + 90.0 : (deltaX < 0.0 && deltaZ >= 0.0 ? Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0 + 180.0 : Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0 + 270.0));
            if (targetYaw - this.minigunYaw > 180.0) {
                targetYaw -= 360.0;
            } else if (this.minigunYaw - targetYaw > 180.0) {
                targetYaw += 360.0;
            }
            targetPitch = Math.toDegrees(Math.atan((posY - this.attackTarget.field_70163_u - (double)(this.attackTarget.field_70131_O / 2.0f)) / PneumaticCraftUtils.distBetween(posX, posZ, this.attackTarget.field_70165_t, this.attackTarget.field_70161_v)));
            this.minigunPitch = this.minigunPitch > targetPitch ? (this.minigunPitch - 10.0 > targetPitch ? (this.minigunPitch -= 10.0) : targetPitch) : (this.minigunPitch + 10.0 < targetPitch ? (this.minigunPitch += 10.0) : targetPitch);
            this.minigunYaw = this.minigunPitch < -80.0 || this.minigunPitch > 80.0 ? targetYaw : (this.minigunYaw > targetYaw ? (this.minigunYaw - 10.0 > targetYaw ? (this.minigunYaw -= 10.0) : targetYaw) : (this.minigunYaw + 10.0 < targetYaw ? (this.minigunYaw += 10.0) : targetYaw));
            this.gunAimedAtTarget = this.minigunYaw == targetYaw && this.minigunPitch == targetPitch;
        } else if (this.isSweeping()) {
            this.minigunYaw -= Math.cos(this.sweepingProgress) * 22.0;
            this.sweepingProgress += 0.05;
            this.minigunYaw += Math.cos(this.sweepingProgress) * 22.0;
            this.minigunPitch = this.minigunPitch > targetPitch ? (this.minigunPitch - 10.0 > targetPitch ? (this.minigunPitch -= 10.0) : targetPitch) : (this.minigunPitch + 10.0 < targetPitch ? (this.minigunPitch += 10.0) : targetPitch);
        }
        if (!this.world.field_72995_K && this.isMinigunActivated() && this.getMinigunSpeed() == 0.4 && (!this.requiresTarget || this.gunAimedAtTarget && this.attackTarget != null) && this.getMinigunSoundCounter() <= 0) {
            this.setMinigunSoundCounter(20);
        }
        if (this.getMinigunSoundCounter() > 0) {
            this.setMinigunSoundCounter(this.getMinigunSoundCounter() - 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(double x, double y, double z, double gunRadius) {
        if (this.isMinigunActivated() && this.getMinigunSpeed() == 0.4 && this.gunAimedAtTarget && this.attackTarget != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
            GlStateManager.func_179090_x();
            GL11.glEnable((int)2852);
            RenderUtils.glColorHex(0xFF000000 | this.getAmmoColor());
            for (int i = 0; i < 5; ++i) {
                int stipple = 0xFFFF & ~(2 << this.rand.nextInt(16));
                GL11.glLineStipple((int)4, (short)((short)stipple));
                Vec3d vec = new Vec3d(this.attackTarget.field_70165_t - x, this.attackTarget.field_70163_u - y, this.attackTarget.field_70161_v - z).func_72432_b();
                this.minigunFire.startX = x + vec.field_72450_a * gunRadius;
                this.minigunFire.startY = y + vec.field_72448_b * gunRadius;
                this.minigunFire.startZ = z + vec.field_72449_c * gunRadius;
                this.minigunFire.endX = this.attackTarget.field_70165_t + this.rand.nextDouble() - 0.5;
                this.minigunFire.endY = this.attackTarget.field_70163_u + (double)(this.attackTarget.field_70131_O / 2.0f) + this.rand.nextDouble() - 0.5;
                this.minigunFire.endZ = this.attackTarget.field_70161_v + this.rand.nextDouble() - 0.5;
                this.minigunFire.render();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2852);
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }
}

