/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.item.ItemMinigun;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.lib.EnumCustomParticleType;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerPneumaticArmor {
    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayer && event.getDistance() > 3.0f && !event.getEntity().field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) {
                return;
            }
            CommonHUDHandler handler = CommonHUDHandler.getHandlerForPlayer(player);
            if (!handler.isArmorEnabled()) {
                return;
            }
            if (event.getEntity().field_70170_p.func_175659_aa() == EnumDifficulty.HARD && handler.isJetBootsActive()) {
                event.setDamageMultiplier(0.2f);
                return;
            }
            ItemPneumaticArmor boots = (ItemPneumaticArmor)stack.func_77973_b();
            float airNeeded = event.getDistance() * 20.0f;
            float airAvailable = (float)boots.getVolume(stack) * handler.getArmorPressure(EntityEquipmentSlot.FEET);
            if (airAvailable < 1.0f) {
                return;
            }
            if (airAvailable >= airNeeded) {
                event.setCanceled(true);
            } else {
                event.setDamageMultiplier(1.0f - airAvailable / airNeeded);
            }
            int i = 0;
            while ((float)i < event.getDistance() / 2.0f) {
                float sx = player.func_70681_au().nextFloat() * 0.6f - 0.3f;
                float sz = player.func_70681_au().nextFloat() * 0.6f - 0.3f;
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumCustomParticleType.AIR_PARTICLE_DENSE, player.field_70165_t, player.field_70163_u, player.field_70161_v, (double)sx, 0.1, (double)sz), player.field_70170_p);
                ++i;
            }
            NetworkHandler.sendToAllAround(new PacketPlaySound(Sounds.SHORT_HISS, SoundCategory.PLAYERS, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.3f, 0.8f, false), player.field_70170_p);
            handler.addAir(stack, EntityEquipmentSlot.FEET, (int)(-airNeeded));
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            Minigun minigun;
            ItemStack stack;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack armorStack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            if (armorStack.func_77973_b() instanceof ItemPneumaticArmor && event.getSource().func_76347_k()) {
                CommonHUDHandler handler = CommonHUDHandler.getHandlerForPlayer(player);
                if (handler.isArmorEnabled() && handler.getArmorPressure(EntityEquipmentSlot.CHEST) > 0.1f && handler.getUpgradeCount(EntityEquipmentSlot.CHEST, IItemRegistry.EnumUpgrade.SECURITY) > 0) {
                    event.setCanceled(true);
                    player.func_70066_B();
                    if (!player.field_70170_p.field_72995_K) {
                        handler.addAir(armorStack, EntityEquipmentSlot.CHEST, -50);
                        for (int i = 0; i < 2; ++i) {
                            float sx = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
                            float sz = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
                            NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumCustomParticleType.AIR_PARTICLE_DENSE, player.field_70165_t + (double)sx, player.field_70163_u + 1.0, player.field_70161_v + (double)sz, (double)(sx / 4.0f), -0.2, (double)(sz / 4.0f)), player.field_70170_p);
                        }
                        if ((player.field_70173_aa & 0xF) == 0) {
                            NetworkHandler.sendToAllAround(new PacketPlaySound(Sounds.LEAKING_GAS_SOUND, SoundCategory.PLAYERS, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.5f, 0.7f, false), player.field_70170_p);
                            this.tryExtinguish(player);
                        }
                    }
                }
            } else if (event.getSource() instanceof EntityDamageSource && ((EntityDamageSource)event.getSource()).func_180139_w() && event.getSource().func_76346_g() instanceof EntityGuardian && (stack = player.func_184614_ca()).func_77973_b() instanceof ItemMinigun && (minigun = ((ItemMinigun)stack.func_77973_b()).getMinigun(stack, player)) != null && minigun.getMinigunSpeed() >= 0.4) {
                event.setCanceled(true);
            }
        }
    }

    private void tryExtinguish(EntityPlayer player) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos pos = player.func_180425_c().func_177982_a(i, 0, j);
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c() == Blocks.field_150480_ab && player.func_70681_au().nextInt(3) == 0) {
                    player.field_70170_p.func_175698_g(pos);
                    continue;
                }
                if (state.func_177230_c() != Blocks.field_150353_l && state.func_177230_c() != Blocks.field_150356_k || player.func_70681_au().nextInt(5) != 0) continue;
                for (IProperty prop : state.func_177227_a()) {
                    if (!prop.func_177701_a().equals("level")) continue;
                    PropertyInteger iProp = (PropertyInteger)prop;
                    int level = (Integer)state.func_177229_b((IProperty)iProp);
                    player.field_70170_p.func_175656_a(pos, level == 0 ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150347_e.func_176223_P());
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.LEGS);
            if (!(stack.func_77973_b() instanceof ItemPneumaticArmor)) {
                return;
            }
            CommonHUDHandler handler = CommonHUDHandler.getHandlerForPlayer(player);
            if (!handler.isJetBootsActive() && handler.isArmorReady(EntityEquipmentSlot.LEGS) && handler.isJumpBoostEnabled() && handler.getArmorPressure(EntityEquipmentSlot.LEGS) > 0.01f) {
                float scale;
                float power = (float)ItemPneumaticArmor.getIntData(stack, "jumpBoost", 100) / 100.0f;
                int rangeUpgrades = handler.getUpgradeCount(EntityEquipmentSlot.LEGS, IItemRegistry.EnumUpgrade.RANGE, player.func_70093_af() ? 1 : 6);
                float actualBoost = Math.max(1.0f, (float)rangeUpgrades * power);
                player.field_70181_x += (double)(actualBoost * 0.15f);
                float rotRad = player.field_70177_z * ((float)Math.PI / 180);
                float f = scale = player.func_70051_ag() ? 0.25f * actualBoost : 0.15f * actualBoost;
                if (player.field_70159_w != 0.0) {
                    player.field_70159_w -= (double)(MathHelper.func_76126_a((float)rotRad) * scale);
                }
                if (player.field_70179_y != 0.0) {
                    player.field_70179_y += (double)(MathHelper.func_76134_b((float)rotRad) * scale);
                }
                player.field_70143_R = (float)((double)player.field_70143_R - (double)actualBoost * 1.5);
                int airUsed = (int)Math.ceil(20.0f * actualBoost * (float)(player.func_70051_ag() ? 2 : 1));
                handler.addAir(stack, EntityEquipmentSlot.LEGS, -airUsed);
            }
        }
    }
}

