/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.living;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class DebugEntry
implements Comparable<DebugEntry> {
    private static int curId;
    private final int id;
    private final int progWidgetId;
    private final String message;
    private final BlockPos pos;

    public DebugEntry(String message, int progWidgetId, BlockPos pos) {
        this.message = message;
        this.pos = pos != null ? pos : new BlockPos(0, 0, 0);
        this.progWidgetId = progWidgetId;
        this.id = curId++;
    }

    public DebugEntry(ByteBuf buf) {
        this.message = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.id = buf.readInt();
        this.progWidgetId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.id);
        buf.writeInt(this.progWidgetId);
    }

    public String getMessage() {
        return this.message;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getProgWidgetId() {
        return this.progWidgetId;
    }

    public int hashcode() {
        return this.id;
    }

    public boolean equals(Object other) {
        return other instanceof DebugEntry && ((DebugEntry)other).id == this.id;
    }

    @Override
    public int compareTo(DebugEntry o) {
        return Integer.compare(this.id, o.id);
    }
}

