/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor.entitytracker;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.RenderDroneAI;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.RenderTarget;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.hacking.HackableHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.HackUpgradeRenderHandler;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class EntityTrackHandler {
    private static final List<IEntityTrackEntry> trackEntries = new ArrayList<IEntityTrackEntry>();

    public static void registerDefaultEntries() {
        IPneumaticHelmetRegistry manager = PneumaticRegistry.getInstance().getHelmetRegistry();
        manager.registerEntityTrackEntry(EntityTrackEntryLivingBase.class);
        manager.registerEntityTrackEntry(EntityTrackEntryHackable.class);
        manager.registerEntityTrackEntry(EntityTrackEntryDrone.class);
        manager.registerEntityTrackEntry(EntityTrackEntryPressurizable.class);
        manager.registerEntityTrackEntry(EntityTrackEntryAgeable.class);
        manager.registerEntityTrackEntry(EntityTrackEntryTameable.class);
        manager.registerEntityTrackEntry(EntityTrackEntryCreeper.class);
        manager.registerEntityTrackEntry(EntityTrackEntrySlime.class);
        manager.registerEntityTrackEntry(EntityTrackEntryPlayer.class);
        manager.registerEntityTrackEntry(EntityTrackEntryMob.class);
    }

    public static void init() {
        for (Class<? extends IEntityTrackEntry> clazz : PneumaticHelmetRegistry.getInstance().entityTrackEntries) {
            try {
                trackEntries.add(clazz.newInstance());
            }
            catch (InstantiationException e) {
                Log.error("[Entity Tracker] Couldn't registrate " + clazz.getName() + ". Does it have a parameterless constructor?");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Log.error("[Entity Tracker] Couldn't registrate " + clazz.getName() + ". Is it a public class?");
                e.printStackTrace();
            }
        }
    }

    public static List<IEntityTrackEntry> getTrackersForEntity(Entity entity) {
        ArrayList<IEntityTrackEntry> trackers = new ArrayList<IEntityTrackEntry>();
        for (IEntityTrackEntry tracker : trackEntries) {
            if (!tracker.isApplicable(entity)) continue;
            try {
                IEntityTrackEntry newTracker = (IEntityTrackEntry)tracker.getClass().newInstance();
                newTracker.isApplicable(entity);
                trackers.add(newTracker);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return trackers;
    }

    private static ItemStack[] asItemStackArray(NonNullList<ItemStack> stacks) {
        ItemStack[] result = new ItemStack[stacks.size()];
        for (int i = 0; i < stacks.size(); ++i) {
            result[i] = (ItemStack)stacks.get(i);
        }
        return result;
    }

    public static class EntityTrackEntryHackable
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return HackUpgradeRenderHandler.enabledForPlayer(PneumaticCraftRepressurized.proxy.getClientPlayer());
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo) {
            IHackableEntity hackable = HackableHandler.getHackableForEntity(entity, PneumaticCraftRepressurized.proxy.getClientPlayer());
            if (hackable != null) {
                List<RenderTarget> targets = HUDHandler.instance().getSpecificRenderer(EntityTrackUpgradeHandler.class).getTargets();
                int hackTime = 0;
                for (RenderTarget target : targets) {
                    if (target.entity != entity) continue;
                    hackTime = target.getHackTime();
                    break;
                }
                if (hackTime == 0) {
                    hackable.addInfo(entity, curInfo, PneumaticCraftRepressurized.proxy.getClientPlayer());
                } else {
                    int requiredHackTime = hackable.getHackTime(entity, PneumaticCraftRepressurized.proxy.getClientPlayer());
                    int percentageComplete = hackTime * 100 / requiredHackTime;
                    if (percentageComplete < 100) {
                        curInfo.add("Hacking... (" + percentageComplete + "%%)");
                    } else if (hackTime < requiredHackTime + 20) {
                        hackable.addPostHackInfo(entity, curInfo, PneumaticCraftRepressurized.proxy.getClientPlayer());
                    } else {
                        hackable.addInfo(entity, curInfo, PneumaticCraftRepressurized.proxy.getClientPlayer());
                    }
                }
            }
        }
    }

    public static class EntityTrackEntryPlayer
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityPlayer;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean isArmorEmpty = true;
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (stack == null) continue;
                isArmorEmpty = false;
                break;
            }
            boolean isMainInventoryEmpty = true;
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack == null) continue;
                isMainInventoryEmpty = false;
                break;
            }
            curInfo.add(TextFormatting.GRAY + "Armor:" + (isArmorEmpty ? " -" : ""));
            PneumaticCraftUtils.sortCombineItemStacksAndToString(curInfo, EntityTrackHandler.asItemStackArray((NonNullList<ItemStack>)player.field_71071_by.field_70460_b));
            curInfo.add(TextFormatting.GRAY + "Held item:" + (isMainInventoryEmpty ? " -" : ""));
            PneumaticCraftUtils.sortCombineItemStacksAndToString(curInfo, EntityTrackHandler.asItemStackArray((NonNullList<ItemStack>)player.field_71071_by.field_70462_a));
        }
    }

    public static class EntityTrackEntryCreeper
    extends IEntityTrackEntry.EntityTrackEntry {
        private int creeperInFuseTime;

        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityCreeper;
        }

        @Override
        public void update(Entity entity) {
            if (((EntityCreeper)entity).func_70832_p() == 1) {
                ++this.creeperInFuseTime;
                if (this.creeperInFuseTime > 30) {
                    this.creeperInFuseTime = 30;
                }
            } else {
                --this.creeperInFuseTime;
                if (this.creeperInFuseTime < 0) {
                    this.creeperInFuseTime = 0;
                }
            }
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo) {
            if (this.creeperInFuseTime > 0) {
                if (((EntityCreeper)entity).func_70832_p() == 1) {
                    curInfo.add(TextFormatting.RED + "FUSE: " + (float)Math.round((float)(30 - this.creeperInFuseTime) / 20.0f * 10.0f) / 10.0f + "s !");
                } else {
                    curInfo.add(TextFormatting.DARK_GREEN + "Cooling down: " + (float)Math.round((float)(30 - this.creeperInFuseTime) / 20.0f * 10.0f) / 10.0f + "s !");
                }
            }
        }
    }

    public static class EntityTrackEntryTameable
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityTameable;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo) {
            EntityLivingBase owner = ((EntityTameable)entity).func_70902_q();
            if (owner != null) {
                curInfo.add("Owner: " + owner.func_70005_c_());
            } else {
                curInfo.add("This animal can be tamed");
            }
        }
    }

    public static class EntityTrackEntryAgeable
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityAgeable;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo) {
            int growingAge = ((EntityAgeable)entity).func_70874_b();
            if (growingAge > 0) {
                curInfo.add("Can breed in " + PneumaticCraftUtils.convertTicksToMinutesAndSeconds(growingAge, false));
            } else if (growingAge < 0) {
                curInfo.add("Becomes adult in " + PneumaticCraftUtils.convertTicksToMinutesAndSeconds(-growingAge, false));
            } else {
                curInfo.add("This animal can be bred");
            }
        }
    }

    public static class EntityTrackEntryMob
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityMob;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo) {
            EntityLivingBase target = ((EntityMob)entity).func_70638_az();
            curInfo.add("Target: " + (target != null ? target.func_70005_c_() : "-"));
        }
    }

    public static class EntityTrackEntrySlime
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntitySlime;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo) {
            switch (((EntitySlime)entity).func_70809_q()) {
                case 1: {
                    curInfo.add("Size: Tiny");
                    return;
                }
                case 2: {
                    curInfo.add("Size: Small");
                    return;
                }
                case 4: {
                    curInfo.add("Size: Big");
                    return;
                }
            }
            curInfo.add("Size: " + ((EntitySlime)entity).func_70809_q());
        }
    }

    public static class EntityTrackEntryLivingBase
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof EntityLivingBase;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo) {
            int healthPercentage = (int)(((EntityLivingBase)entity).func_110143_aJ() / ((EntityLivingBase)entity).func_110138_aP() * 100.0f);
            curInfo.add("Health: " + healthPercentage + "%%");
        }
    }

    public static class EntityTrackEntryPressurizable
    extends IEntityTrackEntry.EntityTrackEntry {
        @Override
        public boolean isApplicable(Entity entity) {
            return entity instanceof IPressurizable;
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo) {
            curInfo.add("Pressure: " + PneumaticCraftUtils.roundNumberTo(((IPressurizable)entity).getPressure(null), 1) + " bar");
        }
    }

    public static class EntityTrackEntryDrone
    extends IEntityTrackEntry.EntityTrackEntry {
        private RenderDroneAI droneAIRenderer;

        @Override
        public boolean isApplicable(Entity entity) {
            if (entity instanceof EntityDrone) {
                this.droneAIRenderer = new RenderDroneAI((EntityDrone)entity);
                return true;
            }
            return false;
        }

        public RenderDroneAI getDroneAIRenderer() {
            return this.droneAIRenderer;
        }

        @Override
        public void update(Entity entity) {
            this.droneAIRenderer.update();
        }

        @Override
        public void render(Entity entity, float partialTicks) {
            this.droneAIRenderer.render(partialTicks);
        }

        @Override
        public void addInfo(Entity entity, List<String> curInfo) {
            curInfo.add("Owner: " + ((EntityDrone)entity).playerName);
            curInfo.add("Routine: " + ((EntityDrone)entity).getLabel());
            EntityPlayer player = PneumaticCraftRepressurized.proxy.getClientPlayer();
            if (DroneDebugUpgradeHandler.enabledForPlayer(player)) {
                if (NBTUtil.getInteger(player.func_184582_a(EntityEquipmentSlot.HEAD), "debuggingDrone") == entity.func_145782_y()) {
                    curInfo.add(TextFormatting.GOLD + "Debugging this drone");
                    curInfo.add(TextFormatting.GOLD + "Press [" + Keyboard.getKeyName((int)KeyHandler.getInstance().keybindOpenOptions.func_151463_i()) + "] for debugger");
                } else {
                    curInfo.add(TextFormatting.GOLD + "Press [" + Keyboard.getKeyName((int)KeyHandler.getInstance().keybindDebuggingDrone.func_151463_i()) + "] to debug");
                }
            }
        }
    }
}

