/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableEntity;
import me.desht.pneumaticcraft.client.gui.pneumaticHelmet.GuiDroneDebuggerOptions;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.RenderProgressBar;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.RenderDroneAI;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.RenderTargetCircle;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.entitytracker.EntityTrackHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityStart;
import me.desht.pneumaticcraft.common.network.PacketUpdateDebuggingDrone;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderTarget {
    public final Entity entity;
    private final RenderTargetCircle circle1;
    private final RenderTargetCircle circle2;
    public int ticksExisted = 0;
    private float oldSize;
    @SideOnly(value=Side.CLIENT)
    private final GuiAnimatedStat stat;
    private boolean didMakeLockSound;
    public boolean isLookingAtTarget;
    private List<String> textList = new ArrayList<String>();
    private final List<IEntityTrackEntry> trackEntries;
    private int hackTime;

    public RenderTarget(Entity entity) {
        this.entity = entity;
        this.trackEntries = EntityTrackHandler.getTrackersForEntity(entity);
        this.circle1 = new RenderTargetCircle();
        this.circle2 = new RenderTargetCircle();
        Item droppedItem = null;
        if (entity instanceof EntityLiving) {
            try {
                droppedItem = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.stat = droppedItem != null ? new GuiAnimatedStat(null, entity.func_70005_c_(), new ItemStack(droppedItem, 1, 0), 20, -20, 0x3000AA00, null, false) : new GuiAnimatedStat(null, entity.func_70005_c_(), "", 20, -20, 0x3000AA00, null, false);
        this.stat.setMinDimensionsAndReset(0, 0);
    }

    public RenderDroneAI getDroneAIRenderer() {
        for (IEntityTrackEntry tracker : this.trackEntries) {
            if (!(tracker instanceof EntityTrackHandler.EntityTrackEntryDrone)) continue;
            return ((EntityTrackHandler.EntityTrackEntryDrone)tracker).getDroneAIRenderer();
        }
        throw new IllegalStateException("[RenderTarget] Drone entity, but no drone AI Renderer?");
    }

    public void update() {
        this.stat.update();
        this.stat.setTitle(this.entity.func_70005_c_());
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (this.ticksExisted >= 30 && !this.didMakeLockSound) {
            this.didMakeLockSound = true;
            player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, Sounds.HUD_ENTITY_LOCK, SoundCategory.PLAYERS, 0.1f, 1.0f, true);
        }
        boolean tagged = NBTUtil.getInteger(player.func_184582_a(EntityEquipmentSlot.HEAD), "debuggingDrone") == this.entity.func_145782_y();
        this.circle1.setRenderingAsTagged(tagged);
        this.circle2.setRenderingAsTagged(tagged);
        this.circle1.update();
        this.circle2.update();
        for (IEntityTrackEntry tracker : this.trackEntries) {
            tracker.update(this.entity);
        }
        this.isLookingAtTarget = this.isPlayerLookingAtTarget();
        if (this.hackTime > 0) {
            IHackableEntity hackableEntity = HackableHandler.getHackableForEntity(this.entity, PneumaticCraftRepressurized.proxy.getClientPlayer());
            this.hackTime = hackableEntity != null ? ++this.hackTime : 0;
        }
    }

    public boolean isInitialized() {
        return this.ticksExisted > 120;
    }

    public void render(float partialTicks, boolean justRenderWhenHovering) {
        float blue;
        float green;
        float red;
        for (IEntityTrackEntry tracker : this.trackEntries) {
            tracker.render(this.entity, partialTicks);
        }
        double x = this.entity.field_70169_q + (this.entity.field_70165_t - this.entity.field_70169_q) * (double)partialTicks;
        double y = this.entity.field_70167_r + (this.entity.field_70163_u - this.entity.field_70167_r) * (double)partialTicks + (double)this.entity.field_70131_O / 2.0;
        double z = this.entity.field_70166_s + (this.entity.field_70161_v - this.entity.field_70166_s) * (double)partialTicks;
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179094_E();
        GlStateManager.func_179086_m((int)256);
        float alpha = 0.5f;
        if (this.entity instanceof EntityDrone) {
            red = 1.0f;
            green = 1.0f;
            blue = 0.0f;
        } else if (this.entity instanceof EntityMob || this.entity instanceof EntitySlime) {
            red = 1.0f;
            green = 0.0f;
            blue = 0.0f;
        } else {
            red = 0.0f;
            green = 1.0f;
            blue = 0.0f;
        }
        float size = this.entity.field_70131_O * 0.5f;
        if (this.ticksExisted < 60) {
            size += 5.0f - (float)Math.abs(this.ticksExisted) * 0.083f;
            alpha = (float)Math.abs(this.ticksExisted) * 0.005f;
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f - Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        float renderSize = this.oldSize + (size - this.oldSize) * partialTicks;
        this.circle1.render(renderSize, partialTicks);
        this.circle2.render((double)renderSize + 0.2, partialTicks);
        int targetAcquireProgress = (int)((float)(this.ticksExisted - 50) / 0.7f);
        if (this.ticksExisted <= 120 && this.ticksExisted > 50) {
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)0.8f);
            RenderProgressBar.render(0.0, 0.4, 1.8, 0.9, 0.0, targetAcquireProgress);
        }
        GlStateManager.func_179098_w();
        FontRenderer fontRenderer = Minecraft.func_71410_x().func_175598_ae().func_78716_a();
        GlStateManager.func_179139_a((double)0.02, (double)0.02, (double)0.02);
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        if (this.ticksExisted > 120) {
            if (justRenderWhenHovering && !this.isLookingAtTarget) {
                this.stat.closeWindow();
            } else {
                this.stat.openWindow();
            }
            this.textList = new ArrayList<String>();
            for (IEntityTrackEntry tracker : this.trackEntries) {
                tracker.addInfo(this.entity, this.textList);
            }
            this.stat.setText(this.textList);
            this.stat.render(-1, -1, partialTicks);
        } else if (this.ticksExisted > 50) {
            fontRenderer.func_78276_b("Acquiring Target...", 0, 0, 0x7F7F7F);
            fontRenderer.func_78276_b(targetAcquireProgress + "%", 37, 28, 12032);
        } else if (this.ticksExisted < -30) {
            this.stat.closeWindow();
            this.stat.render(-1, -1, partialTicks);
            fontRenderer.func_78276_b("Lost Target!", 0, 0, 0xFF0000);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        this.oldSize = size;
    }

    public List<String> getEntityText() {
        return this.textList;
    }

    private boolean isPlayerLookingAtTarget() {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        WorldClient world = FMLClientHandler.instance().getClient().field_71441_e;
        Vec3d vec3 = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec31 = new Vec3d(this.entity.field_70165_t - player.field_70165_t, this.entity.func_174813_aQ().field_72338_b + (double)(this.entity.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e()), this.entity.field_70161_v - player.field_70161_v);
        double d0 = vec31.func_72433_c();
        double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
        return d1 > 1.0 - 0.05 / d0;
    }

    public void hack() {
        IHackableEntity hackable;
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && (hackable = HackableHandler.getHackableForEntity(this.entity, PneumaticCraftRepressurized.proxy.getClientPlayer())) != null && (this.hackTime == 0 || this.hackTime > hackable.getHackTime(this.entity, PneumaticCraftRepressurized.proxy.getClientPlayer()))) {
            NetworkHandler.sendToServer(new PacketHackingEntityStart(this.entity));
        }
    }

    public void selectAsDebuggingTarget() {
        if (this.isInitialized() && this.isPlayerLookingAtTarget() && this.entity instanceof EntityDrone) {
            GuiDroneDebuggerOptions.clearAreaShowWidgetId();
            NetworkHandler.sendToServer(new PacketUpdateDebuggingDrone(this.entity.func_145782_y()));
            Minecraft.func_71410_x().field_71439_g.func_184185_a(Sounds.HUD_ENTITY_LOCK, 1.0f, 2.0f);
        }
    }

    public void onHackConfirmServer() {
        this.hackTime = 1;
    }

    public int getHackTime() {
        return this.hackTime;
    }

    public boolean scroll(MouseEvent event) {
        if (this.isInitialized() && this.isPlayerLookingAtTarget()) {
            return this.stat.handleMouseWheel(event.getDwheel());
        }
        return false;
    }
}

