/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumaticHelmet;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.GuiUnitProgrammer;
import me.desht.pneumaticcraft.client.gui.widget.GuiCheckBox;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.common.entity.living.DebugEntry;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class GuiDroneDebuggerOptions
extends Gui
implements IOptionPage {
    private static final int PROGAMMING_MARGIN = 20;
    private static final int PROGRAMMING_START_Y = 40;
    private final DroneDebugUpgradeHandler upgradeHandler;
    private EntityDrone selectedDrone;
    private GuiUnitProgrammer programmerUnit;
    private int programmingStartX;
    private int programmingWidth;
    private int programmingHeight;
    private IProgWidget areaShowingWidget;
    private int screenWidth;
    private int screenHeight;
    private GuiButton showActive;
    private GuiButton showStart;
    private GuiCheckBox followCheckbox;
    private static int areaShowWidgetId = -1;

    public GuiDroneDebuggerOptions(DroneDebugUpgradeHandler upgradeHandler) {
        this.upgradeHandler = upgradeHandler;
    }

    public static void clearAreaShowWidgetId() {
        areaShowWidgetId = -1;
    }

    @Override
    public String getPageName() {
        return "Drone Debugging";
    }

    @Override
    public void initGui(IGuiScreen gui) {
        ItemStack helmet;
        GuiScreen guiScreen = (GuiScreen)gui;
        this.screenWidth = guiScreen.field_146294_l;
        this.screenHeight = guiScreen.field_146295_m;
        if (PneumaticCraftRepressurized.proxy.getClientPlayer() != null && !(helmet = PneumaticCraftRepressurized.proxy.getClientPlayer().func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b()) {
            int entityId = NBTUtil.getInteger(helmet, "debuggingDrone");
            Entity entity = PneumaticCraftRepressurized.proxy.getClientWorld().func_73045_a(entityId);
            if (entity instanceof EntityDrone) {
                this.selectedDrone = (EntityDrone)entity;
            }
        }
        this.showStart = new GuiButton(10, 30, 128, 150, 20, I18n.func_135052_a((String)"gui.progWidget.debug.showStart", (Object[])new Object[0]));
        gui.getButtonList().add(this.showStart);
        this.showActive = new GuiButton(11, 30, 150, 150, 20, I18n.func_135052_a((String)"gui.progWidget.debug.showActive", (Object[])new Object[0]));
        gui.getButtonList().add(this.showActive);
        this.followCheckbox = new GuiCheckBox(12, 30, 176, -1, " " + I18n.func_135052_a((String)"gui.progWidget.debug.followActive", (Object[])new Object[0]));
        this.followCheckbox.x = 180 - this.followCheckbox.getBounds().width;
        this.programmingStartX = 20;
        this.programmingWidth = guiScreen.field_146294_l - 40;
        this.programmingHeight = guiScreen.field_146295_m - 20 - 40;
        this.programmerUnit = new DebugInfoProgrammerUnit(this.selectedDrone != null ? this.selectedDrone.getProgWidgets() : new ArrayList(), gui.getFontRenderer(), 0, 0, guiScreen.field_146294_l, guiScreen.field_146295_m, 100, this.programmingStartX, 40, this.programmingWidth, this.programmingHeight, 0, 0, 0);
        if (this.selectedDrone != null) {
            this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(this.selectedDrone.getProgWidgets(), ProgWidgetStart.class));
        }
    }

    @Override
    public void actionPerformed(GuiButton button) {
        if (this.selectedDrone != null) {
            if (button.field_146127_k == 10) {
                this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(this.selectedDrone.getProgWidgets(), ProgWidgetStart.class));
            } else if (button.field_146127_k == 11) {
                this.programmerUnit.gotoPiece(this.selectedDrone.getActiveWidget());
            }
        }
    }

    @Override
    public void drawPreButtons(int x, int y, float partialTicks) {
        GuiDroneDebuggerOptions.func_73734_a((int)this.programmingStartX, (int)40, (int)(this.programmingStartX + this.programmingWidth), (int)(40 + this.programmingHeight), (int)0x55000000);
    }

    @Override
    public void drawScreen(int x, int y, float partialTicks) {
        IProgWidget widget;
        if (this.selectedDrone != null) {
            Minecraft.func_71410_x().field_71466_p.func_175065_a("Drone name: " + this.selectedDrone.func_70005_c_(), 20.0f, (float)(this.screenHeight - 15), -1, true);
            Minecraft.func_71410_x().field_71466_p.func_175065_a("Routine: " + this.selectedDrone.getLabel(), (float)(this.screenWidth / 2), (float)(this.screenHeight - 15), -1, true);
        }
        this.programmerUnit.render(x, y, true, true, true);
        this.programmerUnit.renderForeground(x, y, null);
        this.followCheckbox.render(x, y, partialTicks);
        if (this.selectedDrone == null) {
            this.func_73732_a(Minecraft.func_71410_x().field_71466_p, "Press '" + Keyboard.getKeyName((int)KeyHandler.getInstance().keybindDebuggingDrone.func_151463_i()) + "' on a Drone when tracked by an Entity Tracker to debug the Drone.", this.screenWidth / 2, this.screenHeight / 2, -65536);
        }
        if ((widget = this.programmerUnit.getHoveredWidget(x, y)) == null) {
            widget = this.areaShowingWidget;
        }
        this.upgradeHandler.getShowingPositions().clear();
        if (widget != null) {
            int widgetId = this.selectedDrone.getProgWidgets().indexOf(widget);
            for (DebugEntry entry : this.selectedDrone.getDebugEntries()) {
                if (entry.getProgWidgetId() != widgetId || entry.getPos().equals((Object)new BlockPos(0, 0, 0))) continue;
                this.upgradeHandler.getShowingPositions().add(entry.getPos());
            }
        }
    }

    @Override
    public void updateScreen() {
        this.showStart.field_146124_l = this.selectedDrone != null && !this.selectedDrone.getProgWidgets().isEmpty();
        boolean bl = this.showActive.field_146124_l = this.selectedDrone != null && this.selectedDrone.getActiveWidget() != null;
        if (this.followCheckbox.checked && this.selectedDrone != null && this.selectedDrone.getActiveWidget() != null) {
            this.programmerUnit.gotoPiece(this.selectedDrone.getActiveWidget());
        }
    }

    @Override
    public void keyTyped(char ch, int key) {
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
        IProgWidget widget;
        if (this.followCheckbox.getBounds().contains(x, y)) {
            this.followCheckbox.onMouseClicked(x, y, button);
        } else if (button == 0) {
            this.areaShowingWidget = this.programmerUnit.getHoveredWidget(x, y);
        } else if (button == 1 && (widget = this.programmerUnit.getHoveredWidget(x, y)) instanceof IAreaProvider) {
            this.upgradeHandler.getShownArea().clear();
            int widgetId = this.selectedDrone.getProgWidgets().indexOf(widget);
            if (areaShowWidgetId != widgetId) {
                HashSet area = Sets.newHashSet();
                ((IAreaProvider)((Object)widget)).getArea(area);
                this.upgradeHandler.getShownArea().addAll(area);
                areaShowWidgetId = widgetId;
            } else {
                GuiDroneDebuggerOptions.clearAreaShowWidgetId();
            }
        }
    }

    @Override
    public void handleMouseInput() {
        this.programmerUnit.getScrollBar().handleMouseInput();
    }

    @Override
    public boolean canBeTurnedOff() {
        return false;
    }

    @Override
    public boolean displaySettingsText() {
        return false;
    }

    private class DebugInfoProgrammerUnit
    extends GuiUnitProgrammer {
        DebugInfoProgrammerUnit(List<IProgWidget> progWidgets, FontRenderer fontRenderer, int guiLeft, int guiTop, int width, int height, int xSize, int startX, int startY, int areaWidth, int areaHeight, int translatedX, int translatedY, int lastZoom) {
            super(progWidgets, fontRenderer, guiLeft, guiTop, width, height, xSize, startX, startY, areaWidth, areaHeight, translatedX, translatedY, lastZoom);
        }

        @Override
        protected void addAdditionalInfoToTooltip(IProgWidget widget, List<String> tooltip) {
            int widgetId = GuiDroneDebuggerOptions.this.selectedDrone.getProgWidgets().indexOf(widget);
            LinkedHashMap<String, Integer> messageTimesMap = new LinkedHashMap<String, Integer>();
            boolean hasCoords = false;
            for (DebugEntry debugEntry : GuiDroneDebuggerOptions.this.selectedDrone.getDebugEntries()) {
                if (debugEntry.getProgWidgetId() != widgetId) continue;
                Integer oldTimes = (Integer)messageTimesMap.get(debugEntry.getMessage());
                if (oldTimes == null) {
                    oldTimes = 0;
                }
                messageTimesMap.put(debugEntry.getMessage(), oldTimes + 1);
                if (debugEntry.getPos().equals((Object)new BlockPos(0, 0, 0))) continue;
                hasCoords = true;
            }
            for (Map.Entry entry : messageTimesMap.entrySet()) {
                tooltip.add(entry.getValue() + "x " + I18n.func_135052_a((String)((String)entry.getKey()), (Object[])new Object[0]));
            }
            if (hasCoords) {
                tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.progWidget.debug.hasPositions", (Object[])new Object[0]));
                if (widget != GuiDroneDebuggerOptions.this.areaShowingWidget) {
                    tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"gui.progWidget.debug.clickToShow", (Object[])new Object[0]));
                }
            }
            if (widget instanceof IAreaProvider) {
                if (widgetId == areaShowWidgetId) {
                    tooltip.add(TextFormatting.GREEN + "Right-Click: " + I18n.func_135052_a((String)"gui.programmer.button.stopShowingArea", (Object[])new Object[0]));
                } else {
                    tooltip.add(TextFormatting.GREEN + "Right-Click: " + I18n.func_135052_a((String)"gui.programmer.button.showArea", (Object[])new Object[0]));
                }
            }
        }

        @Override
        protected void renderAdditionally() {
            if (GuiDroneDebuggerOptions.this.selectedDrone != null && GuiDroneDebuggerOptions.this.selectedDrone.getActiveWidget() != null) {
                this.drawBorder(GuiDroneDebuggerOptions.this.selectedDrone.getActiveWidget(), -16711936);
                if (areaShowWidgetId >= 0) {
                    this.drawBorder(GuiDroneDebuggerOptions.this.selectedDrone.getProgWidgets().get(areaShowWidgetId), -1606352992, 2);
                }
            }
        }
    }
}

