/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiUtils {
    private static final HashMap<String, ResourceLocation> resourceMap = new HashMap();
    private static final int CIRCLE_POINTS = 500;
    public static final double PRESSURE_GAUGE_RADIUS = 20.0;
    private static final double START_ANGLE = 4.1887902047863905;
    private static final double STOP_ANGLE = -1.0471975511965976;
    private static final int GAUGE_POINTS = 416;
    private static final RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;

    public static void drawPressureGauge(FontRenderer fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos, float zLevel) {
        GuiUtils.drawPressureGauge(fontRenderer, minPressure, maxPressure, dangerPressure, minWorkingPressure, currentPressure, xPos, yPos, zLevel, -16777216);
    }

    public static void drawPressureGauge(FontRenderer fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos, float zLevel, int fgColor) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179131_c((float)0.7f, (float)0.0f, (float)0.0f, (float)1.0f);
        wr.func_181668_a(6, DefaultVertexFormats.field_181705_e);
        wr.func_181662_b((double)xPos, (double)yPos, (double)zLevel).func_181675_d();
        int explodeBoundary = 416 - (int)((dangerPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        int workingBoundary = 416 - (int)((minWorkingPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        boolean changedColorGreen = false;
        boolean changedColorYellow = false;
        for (int i = 0; i < 416; ++i) {
            if (i == explodeBoundary && !changedColorGreen) {
                Tessellator.func_178181_a().func_78381_a();
                if (minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f) {
                    GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.0f, (float)1.0f);
                } else {
                    GlStateManager.func_179131_c((float)0.0f, (float)0.7f, (float)0.0f, (float)1.0f);
                }
                wr.func_181668_a(6, DefaultVertexFormats.field_181705_e);
                wr.func_181662_b((double)xPos, (double)yPos, (double)zLevel).func_181675_d();
                --i;
                changedColorGreen = true;
            }
            if (i == workingBoundary && !changedColorYellow) {
                Tessellator.func_178181_a().func_78381_a();
                if (minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f) {
                    GlStateManager.func_179131_c((float)0.0f, (float)0.7f, (float)0.0f, (float)1.0f);
                } else {
                    GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.0f, (float)1.0f);
                }
                wr.func_181668_a(6, DefaultVertexFormats.field_181705_e);
                wr.func_181662_b((double)xPos, (double)yPos, (double)zLevel).func_181675_d();
                --i;
                changedColorYellow = true;
            }
            double angle = (double)(-i) / 500.0 * 2.0 * Math.PI - -1.0471975511965976;
            wr.func_181662_b(Math.cos(angle) * 20.0 + (double)xPos, Math.sin(angle) * 20.0 + (double)yPos, (double)zLevel).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        float fgR = (float)(fgColor >> 16 & 0xFF) / 255.0f;
        float fgB = (float)(fgColor >> 8 & 0xFF) / 255.0f;
        float fgG = (float)(fgColor & 0xFF) / 255.0f;
        float fgA = (float)(fgColor >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)fgR, (float)fgG, (float)fgB, (float)fgA);
        wr.func_181668_a(2, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 500; ++i) {
            double angle = (double)i / 500.0 * 2.0 * Math.PI;
            wr.func_181662_b(Math.cos(angle) * 20.0 + (double)xPos, Math.sin(angle) * 20.0 + (double)yPos, (double)zLevel).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        int currentScale = (int)maxPressure;
        ArrayList<int[]> textScalers = new ArrayList<int[]>();
        wr.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i <= 416; ++i) {
            double angle = (double)(-i) / 500.0 * 2.0 * Math.PI - -1.0471975511965976;
            if (i != 416 - (int)(((float)currentScale - minPressure) / (maxPressure - minPressure) * 416.0f)) continue;
            textScalers.add(new int[]{currentScale--, (int)(Math.cos(angle) * 20.0 * 1.4), (int)(Math.sin(angle) * 20.0 * 1.4)});
            wr.func_181662_b(Math.cos(angle) * 20.0 * 0.9 + (double)xPos, Math.sin(angle) * 20.0 * 0.9 + (double)yPos, (double)zLevel).func_181675_d();
            wr.func_181662_b(Math.cos(angle) * 20.0 * 1.1 + (double)xPos, Math.sin(angle) * 20.0 * 1.1 + (double)yPos, (double)zLevel).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179131_c((float)fgR, (float)fgG, (float)fgB, (float)fgA);
        double angleIndicator = 416 - (int)((currentPressure - minPressure) / (maxPressure - minPressure) * 416.0f);
        angleIndicator = -angleIndicator / 500.0 * 2.0 * Math.PI - -1.0471975511965976;
        wr.func_181668_a(2, DefaultVertexFormats.field_181705_e);
        wr.func_181662_b(Math.cos(angleIndicator + 2.796017461694916) * 20.0 * 0.3 + (double)xPos, Math.sin(angleIndicator + 2.796017461694916) * 20.0 * 0.3 + (double)yPos, (double)zLevel).func_181675_d();
        wr.func_181662_b(Math.cos(angleIndicator + 3.4871678454846706) * 20.0 * 0.3 + (double)xPos, Math.sin(angleIndicator + 3.4871678454846706) * 20.0 * 0.3 + (double)yPos, (double)zLevel).func_181675_d();
        wr.func_181662_b(Math.cos(angleIndicator) * 20.0 * 0.8 + (double)xPos, Math.sin(angleIndicator) * 20.0 * 0.8 + (double)yPos, (double)zLevel).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        while (textScalers.size() > 10) {
            int divider = textScalers.size() / 5;
            for (int i = textScalers.size() - 1; i >= 0; --i) {
                if (i % divider == 0) continue;
                textScalers.remove(i);
            }
        }
        for (int[] scaler : textScalers) {
            fontRenderer.func_78276_b("" + scaler[0], xPos + scaler[1] - 3, yPos + scaler[2] - 3, fgColor);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static ResourceLocation getResourceLocation(String texture) {
        if (resourceMap.containsKey(texture)) {
            return resourceMap.get(texture);
        }
        ResourceLocation resource = new ResourceLocation(texture);
        resourceMap.put(texture, resource);
        return resource;
    }

    public static void drawItemStack(ItemStack stack, int x, int y) {
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        itemRenderer.func_180450_b(stack, x, y);
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
    }

    public static void drawFluid(Rectangle bounds, @Nullable FluidStack fluidStack, @Nullable IFluidTank tank) {
        int scaledAmount;
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
        ResourceLocation fluidStill = fluid.getStill();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
        }
        if (fluidStillSprite == null) {
            fluidStillSprite = textureMapBlocks.func_174944_f();
        }
        int fluidColor = fluid.getColor(fluidStack);
        int n = scaledAmount = tank == null ? bounds.height : fluidStack.amount * bounds.height / tank.getCapacity();
        if (fluidStack.amount > 0 && scaledAmount < 1) {
            scaledAmount = 1;
        }
        scaledAmount = Math.min(scaledAmount, bounds.height);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtils.glColorHex(fluidColor, 255);
        int xTileCount = bounds.width / 16;
        int xRemainder = bounds.width - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = bounds.y + bounds.height;
        if (fluid.getDensity() < 0) {
            yStart -= bounds.height - scaledAmount;
        }
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int w = xTile == xTileCount ? xRemainder : 16;
                int h = yTile == yTileCount ? yRemainder : 16;
                int x = bounds.x + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (bounds.width <= 0 || h <= 0) continue;
                int maskTop = 16 - h;
                int maskRight = 16 - w;
                GuiUtils.drawFluidTexture(x, y, fluidStillSprite, maskTop, maskRight, 100.0);
            }
        }
    }

    private static void drawFluidTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        worldrenderer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        worldrenderer.func_181662_b(xCoord + 16.0 - (double)maskRight, yCoord + (double)maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        worldrenderer.func_181662_b(xCoord, yCoord + (double)maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void showPopupHelpScreen(GuiScreen screen, FontRenderer fontRenderer, List<String> helpText) {
        int y;
        int x;
        int boxWidth = 0;
        int boxHeight = helpText.size() * fontRenderer.field_78288_b;
        for (String s : helpText) {
            boxWidth = Math.max(boxWidth, fontRenderer.func_78256_a(s));
        }
        if (screen instanceof GuiContainer) {
            x = (((GuiContainer)screen).getXSize() - boxWidth) / 2;
            y = (((GuiContainer)screen).getYSize() - boxHeight) / 2;
        } else {
            x = (screen.field_146294_l - boxWidth) / 2;
            y = (screen.field_146295_m - boxHeight) / 2;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)400.0f);
        Gui.func_73734_a((int)(x - 4), (int)(y - 4), (int)(x + boxWidth + 8), (int)(y + boxHeight + 8), (int)-1073741824);
        Gui.func_73734_a((int)(x - 4), (int)(y - 4), (int)(x + boxWidth + 8), (int)(y - 3), (int)-8355712);
        Gui.func_73734_a((int)(x - 4), (int)(y + boxHeight + 8), (int)(x + boxWidth + 8), (int)(y + boxHeight + 9), (int)-8355712);
        Gui.func_73734_a((int)(x - 4), (int)(y - 4), (int)(x - 3), (int)(y + boxHeight + 8), (int)-8355712);
        Gui.func_73734_a((int)(x + boxWidth + 8), (int)(y - 4), (int)(x + boxWidth + 9), (int)(y + boxHeight + 8), (int)-8355712);
        for (String s : helpText) {
            fontRenderer.func_78276_b(s, x, y, -2039584);
            y += fontRenderer.field_78288_b;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
    }
}

