/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.ContainerAssemblyController;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyDrill;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyIOUnit;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyLaser;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAssemblyController
extends GuiPneumaticContainerBase<TileEntityAssemblyController> {
    private GuiAnimatedStat statusStat;

    public GuiAssemblyController(InventoryPlayer player, TileEntityAssemblyController te) {
        super(new ContainerAssemblyController(player, te), te, "pneumaticcraft:textures/gui/gui_assembly_controller.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.statusStat = this.addAnimatedStat("Assembly Controller Status", new ItemStack(Blockss.ASSEMBLY_CONTROLLER), -22016, false);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 18, 21, 0x404040);
        this.field_146289_q.func_78276_b("Prog.", 70, 24, 0x404040);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.statusStat.setText(this.getStatusText());
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        List<IAssemblyMachine> machineList = ((TileEntityAssemblyController)this.te).getMachines();
        boolean platformFound = false;
        boolean drillFound = false;
        boolean laserFound = false;
        boolean IOUnitExportFound = false;
        boolean IOUnitImportFound = false;
        text.add("\u00a77Machine Status:");
        for (IAssemblyMachine machine : machineList) {
            if (machine instanceof TileEntityAssemblyPlatform) {
                platformFound = true;
                text.add(TextFormatting.GREEN + "-Assembly Platform online");
                continue;
            }
            if (machine instanceof TileEntityAssemblyDrill) {
                drillFound = true;
                text.add(TextFormatting.GREEN + "-Assembly Drill online");
                continue;
            }
            if (machine instanceof TileEntityAssemblyIOUnit) {
                if (((TileEntityAssemblyIOUnit)machine).isImportUnit()) {
                    IOUnitImportFound = true;
                    text.add(TextFormatting.GREEN + "-Assembly IO Unit (import) online");
                    continue;
                }
                IOUnitExportFound = true;
                text.add(TextFormatting.GREEN + "-Assembly IO Unit (export) online");
                continue;
            }
            if (!(machine instanceof TileEntityAssemblyLaser)) continue;
            laserFound = true;
            text.add(TextFormatting.GREEN + "-Assembly Laser online");
        }
        if (!platformFound) {
            text.add(TextFormatting.DARK_RED + "-Assembly Platform offline");
        }
        if (!drillFound) {
            text.add(TextFormatting.DARK_RED + "-Assembly Drill offline");
        }
        if (!laserFound) {
            text.add(TextFormatting.DARK_RED + "-Assembly Laser offline");
        }
        if (!IOUnitExportFound) {
            text.add(TextFormatting.DARK_RED + "-Assembly IO Unit (export) offline");
        }
        if (!IOUnitImportFound) {
            text.add(TextFormatting.DARK_RED + "-Assembly IO Unit (import) offline");
        }
        return text;
    }

    @Override
    protected void addProblems(List<String> textList) {
        ((TileEntityAssemblyController)this.te).addProblems(textList);
    }
}

