/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CheckBox;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.filter.IFilterContainer;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.gui.BaseSettingsPanel;
import crazypants.enderio.conduits.gui.GuiExternalConnection;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.network.PacketRedstoneConduitOutputStrength;
import crazypants.enderio.conduits.network.PacketRedstoneConduitSignalColor;
import crazypants.enderio.util.EnumReader;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RedstoneSettings
extends BaseSettingsPanel {
    private static final int ID_INPUT_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_STRONG_BUTTON = GuiExternalConnection.nextButtonId();
    private static final int ID_OUTPUT_COLOR_BUTTON = GuiExternalConnection.nextButtonId();
    @Nonnull
    private ColorButton inputColorB;
    @Nonnull
    private ColorButton outputColorB;
    private CheckBox strongCB;
    @Nonnull
    private String signalColorStr = Lang.GUI_SIGNAL_COLOR.get();
    @Nonnull
    private String signalStrengthStr = Lang.GUI_REDSTONE_SIGNAL_STRENGTH.get();
    @Nonnull
    private IRedstoneConduit insCon;

    public RedstoneSettings(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        super((IWidgetIcon)IconEIO.WRENCH_OVERLAY_REDSTONE, ConduitObject.item_redstone_conduit.getUnlocalisedName(), gui, con, "filter_settings");
        int x = this.leftColumn;
        int y = this.customTop + 4;
        this.insCon = (IRedstoneConduit)con;
        this.inputColorB = new ColorButton((IGuiScreen)gui, ID_INPUT_COLOR_BUTTON, x, y);
        this.inputColorB.setToolTipHeading(Lang.GUI_SIGNAL_COLOR.get());
        DyeColor sigCol = this.insCon.getInputSignalColor(gui.getDir());
        this.inputColorB.setColorIndex(sigCol.ordinal());
        x = this.rightColumn;
        this.outputColorB = new ColorButton((IGuiScreen)gui, ID_OUTPUT_COLOR_BUTTON, x, y);
        this.outputColorB.setToolTipHeading(Lang.GUI_SIGNAL_COLOR.get());
        DyeColor sigColOut = this.insCon.getOutputSignalColor(gui.getDir());
        this.outputColorB.setColorIndex(sigColOut.ordinal());
        this.strongCB = new CheckBox((IGuiScreen)gui, ID_STRONG_BUTTON, x, y += 20);
        this.strongCB.setToolTip(new String[]{Lang.GUI_REDSTONE_SIGNAL_STRENGTH.get()});
    }

    @Override
    public void actionPerformed(@Nonnull GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == ID_INPUT_COLOR_BUTTON) {
            this.insCon.setInputSignalColor(this.gui.getDir(), (DyeColor)EnumReader.get(DyeColor.class, (int)this.inputColorB.getColorIndex()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRedstoneConduitSignalColor(this.insCon, this.gui.getDir(), true));
        } else if (guiButton.field_146127_k == ID_OUTPUT_COLOR_BUTTON) {
            this.insCon.setOutputSignalColor(this.gui.getDir(), (DyeColor)EnumReader.get(DyeColor.class, (int)this.outputColorB.getColorIndex()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRedstoneConduitSignalColor(this.insCon, this.gui.getDir(), false));
        } else if (guiButton.field_146127_k == ID_STRONG_BUTTON && this.strongCB != null) {
            this.insCon.setOutputStrength(this.gui.getDir(), this.strongCB.isSelected());
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRedstoneConduitOutputStrength(this.insCon, this.gui.getDir()));
        } else {
            if (guiButton.field_146127_k == 329) {
                this.doOpenFilterGui(6);
                return;
            }
            if (guiButton.field_146127_k == 330) {
                this.doOpenFilterGui(5);
                return;
            }
        }
    }

    @Override
    protected void initCustomOptions() {
        this.gui.getContainer().setInOutSlotsVisible(true, false, (IConduit)this.insCon);
        this.createGhostSlots();
        this.inputColorB.setColorIndex(this.insCon.getInputSignalColor(this.gui.getDir()).ordinal());
        this.inputColorB.onGuiInit();
        this.outputColorB.setColorIndex(this.insCon.getOutputSignalColor(this.gui.getDir()).ordinal());
        this.outputColorB.onGuiInit();
        this.strongCB.onGuiInit();
        this.strongCB.setSelected(this.insCon.isOutputStrong(this.gui.getDir()));
    }

    @Override
    public boolean updateConduit(@Nonnull IClientConduit conduit) {
        ConnectionMode connectionMode;
        this.con = conduit;
        ConnectionMode connectionMode2 = connectionMode = this.con.containsExternalConnection(this.gui.getDir()) ? this.con.getConnectionMode(this.gui.getDir()) : ConnectionMode.NOT_SET;
        if (this.oldConnectionMode != connectionMode) {
            this.connectionModeChanged(connectionMode);
        }
        return true;
    }

    private void createGhostSlots() {
        NNList filtersOut = new NNList((Object[])new ItemStack[]{new ItemStack(ModObject.itemRedstoneAndFilter.getItemNN()), new ItemStack(ModObject.itemRedstoneNandFilter.getItemNN()), new ItemStack(ModObject.itemRedstoneNorFilter.getItemNN()), new ItemStack(ModObject.itemRedstoneNotFilter.getItemNN()), new ItemStack(ModObject.itemRedstoneOrFilter.getItemNN()), new ItemStack(ModObject.itemRedstoneToggleFilter.getItemNN()), new ItemStack(ModObject.itemRedstoneXnorFilter.getItemNN()), new ItemStack(ModObject.itemRedstoneXorFilter.getItemNN())});
        NNList filtersIn = new NNList((Object[])new ItemStack[]{new ItemStack(ModObject.itemRedstoneSensorFilter.getItemNN()), new ItemStack(ModObject.itemRedstoneTimerFilter.getItemNN())});
        NNList upgrades = new NNList();
        this.gui.getContainer().createGhostSlots(this.gui.getGhostSlotHandler().getGhostSlots(), filtersIn, filtersOut, upgrades);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.gui.getContainer().setInOutSlotsVisible(false, false, (IConduit)this.insCon);
        this.inputColorB.detach();
        this.outputColorB.detach();
        this.strongCB.detach();
    }

    @Override
    protected void renderCustomOptions(int topIn, float par1, int par2, int par3) {
        this.gui.getFontRenderer().func_78276_b(this.signalColorStr, this.left + 31, topIn + 6, ColorUtil.getRGB((Color)Color.darkGray));
        this.gui.getFontRenderer().func_78276_b(this.signalColorStr, this.left + 121, topIn + 6, ColorUtil.getRGB((Color)Color.darkGray));
        this.gui.getFontRenderer().func_78276_b(this.signalStrengthStr, this.left + 121, topIn + 26, ColorUtil.getRGB((Color)Color.darkGray));
    }

    @Override
    @Nonnull
    protected String getInputHeading() {
        return Lang.GUI_REDSTONE_CONDUIT_INPUT_MODE.get();
    }

    @Override
    @Nonnull
    protected String getOutputHeading() {
        return Lang.GUI_REDSTONE_CONDUIT_OUTPUT_MODE.get();
    }

    @Override
    protected boolean hasFilterGui(boolean output) {
        return ((IFilterContainer)this.gui.getContainer()).getFilter(!output ? 5 : 6).hasGui();
    }

    @Override
    protected boolean hasFilters() {
        return true;
    }
}

