/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks.blocks;

import betterwithmods.api.block.IRenderRotationPlacement;
import betterwithmods.client.ClientEventHandler;
import betterwithmods.client.baking.UnlistedPropertyGeneric;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.gameplay.miniblocks.client.MiniCacheInfo;
import betterwithmods.module.gameplay.miniblocks.orientations.BaseOrientation;
import betterwithmods.module.gameplay.miniblocks.tiles.TileMini;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class BlockMini
extends BlockRotate
implements IRenderRotationPlacement {
    public static final IUnlistedProperty<MiniCacheInfo> MINI_INFO = new UnlistedPropertyGeneric<MiniCacheInfo>("mini", MiniCacheInfo.class);

    public BlockMini(Material material) {
        super(material);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.getTile((IBlockAccess)worldIn, pos).map(t -> Float.valueOf(t.getState().func_185887_b(worldIn, pos))).orElse(Float.valueOf(super.func_176195_g(blockState, worldIn, pos))).floatValue();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getTile((IBlockAccess)world, pos).map(t -> Float.valueOf(t.getState().func_177230_c().getExplosionResistance(world, pos, exploder, explosion))).orElse(Float.valueOf(super.getExplosionResistance(world, pos, exploder, explosion))).floatValue();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.addAll((Collection)MiniBlocks.MATERIALS.get((Object)this.field_149764_J).stream().sorted(this::compareBlockStates).map(state -> MiniBlocks.fromParent(this, state)).collect(Collectors.toList()));
    }

    private int compareBlockStates(IBlockState a, IBlockState b) {
        Block blockA = a.func_177230_c();
        Block blockB = b.func_177230_c();
        int compare = Integer.compare(Block.func_149682_b((Block)blockA), Block.func_149682_b((Block)blockB));
        if (compare == 0) {
            return Integer.compare(blockA.func_176201_c(a), blockB.func_176201_c(b));
        }
        return compare;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{MINI_INFO});
    }

    @Nullable
    public abstract TileEntity createTileEntity(@Nonnull World var1, @Nonnull IBlockState var2);

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBS = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        return (IBlockState)this.getTile(world, pos).map(t -> extendedBS.withProperty(MINI_INFO, (Object)MiniCacheInfo.from(t))).orElse(extendedBS);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public Optional<TileMini> getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMini) {
            return Optional.of((TileMini)tile);
        }
        return Optional.empty();
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getTile(source, pos).map(t -> t.getOrientation().getBounds()).orElse(Block.field_185505_j);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        this.rotateBlock(world, pos, EnumFacing.UP);
    }

    public boolean rotateBlock(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        return this.getTile((IBlockAccess)world, pos).map(t -> t.changeOrientation(t.getOrientation().next(), false)).orElse(false);
    }

    @Override
    public IRenderRotationPlacement.RenderFunction getRenderFunction() {
        return ClientEventHandler::renderMiniBlock;
    }

    public abstract BaseOrientation getOrientationFromPlacement(EntityLivingBase var1, @Nullable EnumFacing var2, ItemStack var3, float var4, float var5, float var6);

    @Override
    public AxisAlignedBB getBounds(World world, BlockPos pos, EnumFacing facing, float flX, float flY, float flZ, ItemStack stack, EntityLivingBase placer) {
        return this.getOrientationFromPlacement(placer, facing, stack, flX, flY, flZ).getBounds();
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        drops.add((Object)this.getPickBlock(state, null, (World)world, pos, null));
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return this.getTile((IBlockAccess)world, pos).map(t -> t.getPickBlock(player, target, state)).orElse(new ItemStack((Block)this));
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTile(world, pos).map(t -> t.getState().func_177230_c().isFlammable(world, pos, face)).orElse(false);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTile(world, pos).map(t -> t.getState().func_177230_c().getFireSpreadSpeed(world, pos, face)).orElse(5);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTile(world, pos).map(t -> {
            try {
                return t.getState().func_177230_c().getFlammability(world, pos, face);
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(10);
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        IBlockState parent;
        IExtendedBlockState extendedBlockState;
        MiniCacheInfo info;
        if (state instanceof IExtendedBlockState && (info = (MiniCacheInfo)(extendedBlockState = (IExtendedBlockState)state).getValue(MINI_INFO)) != null && (parent = info.getState()) != null) {
            return parent.func_185905_o();
        }
        return super.func_149656_h(state);
    }
}

