/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks;

import betterwithmods.module.gameplay.miniblocks.ItemMini;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockCorner;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMoulding;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockSiding;
import java.util.Arrays;
import net.minecraft.item.ItemStack;

public enum MiniType {
    SIDING(BlockSiding.class, "siding"),
    MOULDING(BlockMoulding.class, "moulding"),
    CORNER(BlockCorner.class, "corner"),
    UNKNOWN(null, "");

    public static MiniType[] VALUES;
    private Class<? extends BlockMini> block;
    private String name;

    private MiniType(Class<? extends BlockMini> block, String name) {
        this.block = block;
        this.name = name;
    }

    public static boolean matches(MiniType type, ItemStack stack) {
        return MiniType.fromStack(stack).equals((Object)type);
    }

    public static MiniType fromName(String name) {
        return Arrays.stream(VALUES).filter(t -> t.isName(name)).findFirst().orElse(null);
    }

    public static MiniType fromBlock(BlockMini block) {
        return Arrays.stream(VALUES).filter(t -> t.isBlock(block)).findFirst().orElse(null);
    }

    public static MiniType fromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemMini) {
            BlockMini mini = (BlockMini)((ItemMini)stack.func_77973_b()).func_179223_d();
            return MiniType.fromBlock(mini);
        }
        return UNKNOWN;
    }

    private boolean isName(String name) {
        return this.name.equalsIgnoreCase(name);
    }

    private boolean isBlock(BlockMini mini) {
        return this.block.isAssignableFrom(mini.getClass());
    }

    static {
        VALUES = MiniType.values();
    }
}

