/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks;

import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import betterwithmods.module.gameplay.miniblocks.tiles.TileMini;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemMini
extends ItemBlock {
    public ItemMini(Block block) {
        super(block);
    }

    public static IBlockState getState(ItemStack stack) {
        NBTTagCompound tag;
        if (stack != null && stack.func_77973_b() instanceof ItemMini && (tag = stack.func_179543_a("texture")) != null) {
            return NBTUtil.func_190008_d((NBTTagCompound)tag);
        }
        return null;
    }

    public static boolean matches(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (!(a.func_77973_b() instanceof ItemMini) || !(b.func_77973_b() instanceof ItemMini)) {
            return false;
        }
        ItemMini miniA = (ItemMini)a.func_77973_b();
        ItemMini miniB = (ItemMini)b.func_77973_b();
        if (miniA.func_179223_d() != miniB.func_179223_d()) {
            return false;
        }
        IBlockState stateA = ItemMini.getState(a);
        IBlockState stateB = ItemMini.getState(b);
        return stateA != null & stateB != null && stateA.equals(stateB);
    }

    public static boolean placeBlockAt(ItemMini item, ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == item.field_150939_a) {
            ItemMini.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileMini) {
                ItemMini.setNBT((TileMini)tile, world, stack);
            }
            ((BlockMini)item.field_150939_a).onBlockPlacedBy(world, pos, state, (EntityLivingBase)player, stack, side, hitX, hitY, hitZ);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    public static void setNBT(TileMini tile, World worldIn, ItemStack stackIn) {
        MinecraftServer minecraftserver = worldIn.func_73046_m();
        if (minecraftserver == null) {
            return;
        }
        NBTTagCompound data = stackIn.func_179543_a("miniblock");
        if (data != null) {
            if (!worldIn.field_72995_K && tile.func_183000_F()) {
                return;
            }
            NBTTagCompound tileNBT = tile.func_189515_b(new NBTTagCompound());
            NBTTagCompound newNBT = tileNBT.func_74737_b();
            tileNBT.func_179237_a(data);
            if (!tileNBT.equals((Object)newNBT)) {
                tile.func_145839_a(tileNBT);
                tile.func_70296_d();
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        return ItemMini.placeBlockAt(this, stack, player, world, pos, side, hitX, hitY, hitZ, newState);
    }

    public String func_77653_i(ItemStack stack) {
        IBlockState state;
        ItemStack block;
        NBTTagCompound tag = stack.func_179543_a("texture");
        String type = I18n.func_74838_a((String)"bwm.unknown_mini.name").trim();
        if (tag != null && (block = new ItemStack((state = NBTUtil.func_190008_d((NBTTagCompound)tag)).func_177230_c(), 1, state.func_177230_c().func_176201_c(state))).func_77973_b() instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)block.func_77973_b();
            type = itemBlock.func_77653_i(block);
        }
        return I18n.func_74837_a((String)(this.func_77667_c(stack) + ".name"), (Object[])new Object[]{type});
    }
}

