/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.custom;

import betterwithmods.manual.client.manual.segment.InteractiveSegment;
import betterwithmods.manual.client.manual.segment.Segment;
import betterwithmods.manual.client.manual.segment.TextSegment;
import betterwithmods.manual.custom.IJEISegment;
import betterwithmods.module.compat.jei.JEI;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fml.common.Loader;

public final class JEISegment
extends TextSegment
implements InteractiveSegment,
IJEISegment {
    private static final int NORMAL_COLOR = 0x333399;
    private static final int NORMAL_COLOR_HOVER = 0x6666CC;
    private static final int FADE_TIME = 500;
    private final String recipeOutput;
    private long lastHovered = System.currentTimeMillis() - 500L;

    public JEISegment(@Nullable Segment parent, String text) {
        super(parent, text);
        this.recipeOutput = null;
    }

    public JEISegment(Segment parent, String text, String recipeOutput) {
        super(parent, text);
        this.recipeOutput = recipeOutput;
    }

    private static int fadeColor(int c1, int c2, float t) {
        int r1 = c1 >>> 16 & 0xFF;
        int g1 = c1 >>> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >>> 16 & 0xFF;
        int g2 = c2 >>> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }

    @Override
    protected Optional<Integer> color() {
        int color = 0x333399;
        int hoverColor = 0x6666CC;
        int timeSinceHover = (int)(System.currentTimeMillis() - this.lastHovered);
        if (timeSinceHover > 500) {
            return Optional.of(color);
        }
        return Optional.of(JEISegment.fadeColor(hoverColor, color, (float)timeSinceHover / 500.0f));
    }

    @Override
    public Optional<String> tooltip() {
        return Optional.ofNullable(this.recipeOutput);
    }

    @Override
    public boolean onMouseClick(int mouseX, int mouseY) {
        if (Loader.isModLoaded((String)"jei") && JEI.JEI_RUNTIME != null && this.recipeOutput != null) {
            Ingredient i = this.getIngredient(this.recipeOutput);
            JEI.showRecipe(i);
            return true;
        }
        return false;
    }

    @Override
    public void notifyHover() {
        this.lastHovered = System.currentTimeMillis();
    }

    @Override
    public String toString() {
        return String.format("[%s](%s)", this.text(), this.recipeOutput);
    }
}

