/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.world.gen.feature;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockBloodLog;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.StateIngredient;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenBloodTree
extends WorldGenAbstractTree {
    private IBlockState log = BWMBlocks.BLOOD_LOG.func_176223_P();
    private IBlockState leaves = BWMBlocks.BLOOD_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    private BlockIngredient BLOOD_LOG = new StateIngredient(BWMBlocks.BLOOD_LOG);

    public WorldGenBloodTree() {
        super(true);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int height = 5 + rand.nextInt(4);
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int i = pos.func_177956_o(); i <= pos.func_177956_o() + height + 1; ++i) {
                int range = i == pos.func_177956_o() ? 0 : (i <= pos.func_177956_o() + 1 + height - 2 ? 2 : 1);
                BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
                for (int x = pos.func_177958_n() - range; x <= pos.func_177958_n() + range && flag; ++x) {
                    for (int z = pos.func_177952_p() - range; z <= pos.func_177952_p() + range && flag; ++z) {
                        if (i >= 0 && i < world.func_72800_K()) {
                            if (this.isReplaceable(world, (BlockPos)mut.func_181079_c(x, i, z))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            boolean isSustained = world.func_180495_p(pos.func_177977_b()).func_177230_c().canSustainPlant(world.func_180495_p(pos.func_177977_b()), (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)BWMBlocks.BLOOD_SAPLING);
            if (isSustained && pos.func_177956_o() < world.func_72800_K() - height - 1) {
                int y;
                world.func_180495_p(pos.func_177977_b()).func_177230_c().onPlantGrow(world.func_180495_p(pos.func_177977_b()), world, pos.func_177977_b(), pos);
                for (y = pos.func_177956_o() - 3 + height; y <= pos.func_177956_o() + height; ++y) {
                    int w = y - (pos.func_177956_o() + height);
                    int width = 1 - w / 2;
                    for (int x = pos.func_177958_n() - width; x <= pos.func_177958_n() + width; ++x) {
                        int xWide = x - pos.func_177958_n();
                        for (int z = pos.func_177952_p() - width; z <= pos.func_177952_p() + width; ++z) {
                            BlockPos leafPos;
                            IBlockState leafState;
                            int zWide = z - pos.func_177952_p();
                            if (Math.abs(xWide) == width && Math.abs(zWide) == width && (rand.nextInt(2) == 0 || w == 0) || !(leafState = world.func_180495_p(leafPos = new BlockPos(x, y, z))).func_177230_c().isAir(leafState, (IBlockAccess)world, leafPos)) continue;
                            this.func_175903_a(world, leafPos, this.leaves);
                        }
                    }
                }
                for (y = 0; y < height; ++y) {
                    BlockPos up = pos.func_177981_b(y);
                    IBlockState logState = world.func_180495_p(up);
                    if (!logState.func_177230_c().isAir(logState, (IBlockAccess)world, up) && !logState.func_177230_c().isLeaves(logState, (IBlockAccess)world, up)) continue;
                    if (y > height - 4) {
                        this.func_175903_a(world, up, this.log.func_177226_a((IProperty)BlockBloodLog.EXPANDABLE, (Comparable)Boolean.valueOf(world.field_73011_w.func_177495_o())));
                        int face = rand.nextInt(6);
                        if (face <= 1) continue;
                        EnumFacing facing = EnumFacing.func_82600_a((int)face);
                        for (int i = 0; i < 1 + rand.nextInt(2); ++i) {
                            this.generateBranch(world, up.func_177967_a(facing, i), facing);
                        }
                        continue;
                    }
                    this.func_175903_a(world, up, this.log);
                }
                return true;
            }
        }
        return false;
    }

    public void generateBranch(World world, BlockPos pos, EnumFacing facing) {
        BlockPos check;
        IBlockState checkState;
        if (this.isReplaceable(world, pos) && this.canOverwrite(checkState = world.func_180495_p(check = pos.func_177972_a(facing)), world, check)) {
            if (this.findNear(world, check, facing.func_176740_k(), 2, this.BLOOD_LOG) > 3) {
                return;
            }
            world.func_175656_a(check, this.log.func_177226_a((IProperty)BlockBloodLog.EXPANDABLE, (Comparable)Boolean.valueOf(world.field_73011_w.func_177495_o())).func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k())));
            this.doFloodFill(world, check.func_177972_a(facing), world.field_73012_v.nextInt(2) + 2, this.leaves);
        }
    }

    private int findNear(World world, BlockPos pos, EnumFacing.Axis axis, int range, BlockIngredient match) {
        int j = 0;
        for (EnumFacing facing : axis.func_176716_d().func_179516_a()) {
            for (int i = 1; i <= range; ++i) {
                IBlockState state;
                BlockPos offset = pos.func_177967_a(facing, i);
                if (!match.apply(world, offset, state = world.func_180495_p(offset))) continue;
                ++j;
            }
        }
        return j;
    }

    private void doFloodFill(World world, BlockPos pos, int maxRange, IBlockState replace) {
        if (maxRange < 0) {
            return;
        }
        IBlockState current = world.func_180495_p(pos);
        if (current.equals(replace)) {
            return;
        }
        if (this.canOverwrite(current, world, pos)) {
            world.func_175656_a(pos, replace);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                this.doFloodFill(world, pos.func_177972_a(f), maxRange - 1, replace);
            }
        }
    }

    private void generateLeafExpansion(World world, BlockPos pos, EnumFacing.Axis axis) {
    }

    public boolean func_150523_a(Block block) {
        return super.func_150523_a(block) || block == BWMBlocks.BLOOD_LOG;
    }

    private boolean canOverwrite(IBlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        return block.func_176200_f((IBlockAccess)world, pos) || block.isLeaves(state, (IBlockAccess)world, pos);
    }
}

