/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.bulk.recipes;

import betterwithmods.api.recipe.IRecipeOutputs;
import betterwithmods.common.registry.bulk.recipes.BulkRecipe;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MillRecipe
extends BulkRecipe {
    private SoundEvent sound;
    private int ticks;

    public MillRecipe(List<Ingredient> inputs, IRecipeOutputs outputs, int priority, SoundEvent sound, int ticks) {
        super(inputs, outputs, priority);
        this.sound = sound;
        this.ticks = ticks;
    }

    public MillRecipe(@Nonnull List<Ingredient> inputs, @Nonnull List<ItemStack> outputs, int ticks) {
        super(inputs, outputs);
        this.ticks = ticks;
    }

    public MillRecipe(@Nonnull List<Ingredient> inputs, @Nonnull List<ItemStack> outputs) {
        this(inputs, outputs, 200);
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public MillRecipe setSound(SoundEvent sound) {
        this.sound = sound;
        return this;
    }

    public MillRecipe setSound(String sound) {
        SoundEvent s = null;
        if (sound != null && !sound.isEmpty()) {
            try {
                s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(sound));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.setSound(s);
    }

    @Override
    public MillRecipe setPriority(int priority) {
        return (MillRecipe)super.setPriority(priority);
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }
}

