/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityAIMate
extends EntityAIBase {
    private final EntityAnimal animal;
    private final Class<? extends EntityAnimal> mateClass;
    private final World world;
    private final double moveSpeed;
    private int spawnBabyDelay;
    private double distance;
    private EntityAnimal targetMate;

    public EntityAIMate(EntityAnimal animal, double speedIn, double distance) {
        this(animal, speedIn, animal.getClass(), distance);
    }

    public EntityAIMate(EntityAnimal p_i47306_1_, double p_i47306_2_, Class<? extends EntityAnimal> p_i47306_4_, double distance) {
        this.animal = p_i47306_1_;
        this.world = p_i47306_1_.field_70170_p;
        this.mateClass = p_i47306_4_;
        this.moveSpeed = p_i47306_2_;
        this.distance = distance;
        this.func_75248_a(3);
    }

    private static Vec3d getMidpoint(Vec3d a, Vec3d b) {
        return new Vec3d((a.field_72450_a + b.field_72450_a) / 2.0, (a.field_72448_b + b.field_72448_b) / 2.0, (a.field_72449_c + b.field_72449_c) / 2.0);
    }

    public boolean func_75250_a() {
        if (!this.animal.func_70880_s()) {
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean func_75253_b() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.animal.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.animal.func_70646_bf());
        this.animal.func_70661_as().func_75497_a((Entity)this.targetMate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.animal.func_70068_e((Entity)this.targetMate) < this.distance) {
            this.spawnBaby();
        }
    }

    private EntityAnimal getNearbyMate() {
        List list = this.world.func_72872_a(this.mateClass, this.animal.func_174813_aQ().func_186662_g(8.0));
        double d0 = Double.MAX_VALUE;
        EntityAnimal entityanimal = null;
        for (EntityAnimal entityanimal1 : list) {
            if (!this.animal.func_70878_b(entityanimal1) || !(this.animal.func_70068_e((Entity)entityanimal1) < d0)) continue;
            entityanimal = entityanimal1;
            d0 = this.animal.func_70068_e((Entity)entityanimal1);
        }
        return entityanimal;
    }

    private void spawnBaby() {
        EntityAgeable entityageable = this.animal.func_90011_a((EntityAgeable)this.targetMate);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((EntityLiving)this.animal, (EntityLiving)this.targetMate, entityageable);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        entityageable = event.getChild();
        if (cancelled) {
            this.animal.func_70873_a(6000);
            this.targetMate.func_70873_a(6000);
            this.animal.func_70875_t();
            this.targetMate.func_70875_t();
            return;
        }
        if (entityageable != null) {
            EntityPlayerMP entityplayermp = this.animal.func_191993_do();
            if (entityplayermp == null && this.targetMate.func_191993_do() != null) {
                entityplayermp = this.targetMate.func_191993_do();
            }
            if (entityplayermp != null) {
                entityplayermp.func_71029_a(StatList.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(entityplayermp, this.animal, this.targetMate, entityageable);
            }
            this.animal.func_70873_a(6000);
            this.targetMate.func_70873_a(6000);
            this.animal.func_70875_t();
            this.targetMate.func_70875_t();
            entityageable.func_70873_a(-24000);
            Vec3d a = event.getParentA().func_174791_d();
            Vec3d b = event.getParentB().func_174791_d();
            Vec3d m = EntityAIMate.getMidpoint(a, b);
            entityageable.func_70012_b(m.field_72450_a, m.field_72448_b, m.field_72449_c, 0.0f, 0.0f);
            this.world.func_72838_d((Entity)entityageable);
            Random random = this.animal.func_70681_au();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextDouble() * (double)entityageable.field_70130_N * 2.0 - (double)entityageable.field_70130_N;
                double d4 = 0.5 + random.nextDouble() * (double)entityageable.field_70131_O;
                double d5 = random.nextDouble() * (double)entityageable.field_70130_N * 2.0 - (double)entityageable.field_70130_N;
                entityageable.field_70170_p.func_175688_a(EnumParticleTypes.HEART, entityageable.field_70165_t + d3, entityageable.field_70163_u + d4, entityageable.field_70161_v + d5, d0, d1, d2, new int[0]);
            }
            if (entityageable.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                entityageable.field_70170_p.func_72838_d((Entity)new EntityXPOrb(entityageable.field_70170_p, entityageable.field_70165_t, entityageable.field_70163_u, entityageable.field_70161_v, random.nextInt(7) + 1));
            }
        }
    }
}

