/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityFallingGourd
extends EntityFallingBlock {
    private static final DataParameter<Integer> FALLBLOCK = EntityDataManager.func_187226_a(EntityFallingGourd.class, (DataSerializer)DataSerializers.field_187192_b);
    private ItemStack seedStack = ItemStack.field_190927_a;
    private SoundEvent shatterSound = SoundEvents.field_187886_fs;
    private boolean smashOnImpact = false;

    public EntityFallingGourd(World worldIn) {
        super(worldIn);
    }

    public EntityFallingGourd(World worldIn, double x, double y, double z, IBlockState fallingBlockState) {
        super(worldIn, x, y, z, fallingBlockState);
        this.setBlock(fallingBlockState);
    }

    public void func_70071_h_() {
        IBlockState fallblock = this.func_175131_l();
        Block block = fallblock.func_177230_c();
        if (fallblock.func_185904_a() == Material.field_151579_a) {
            this.func_70106_y();
        } else {
            BlockPos blockpos1;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            if (this.field_145812_b++ == 0) {
                blockpos1 = new BlockPos((Entity)this);
                if (this.func_130014_f_().func_180495_p(blockpos1).func_177230_c() == block) {
                    this.func_130014_f_().func_175698_g(blockpos1);
                } else if (!this.func_130014_f_().field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.04f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)0.98f;
            if (!this.func_130014_f_().field_72995_K) {
                blockpos1 = new BlockPos((Entity)this);
                if (this.field_70122_E) {
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos1);
                    if (this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)) && BlockFalling.func_185759_i((IBlockState)this.func_130014_f_().func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.01, this.field_70161_v)))) {
                        this.field_70122_E = false;
                        return;
                    }
                    this.field_70159_w *= 0.7;
                    this.field_70179_y *= 0.7;
                    this.field_70181_x *= -0.5;
                    if (10 + this.field_70146_Z.nextInt(7) <= this.field_145812_b) {
                        this.smashOnImpact = true;
                    }
                    if (iblockstate.func_177230_c() != Blocks.field_180384_M) {
                        if (!this.smashOnImpact && this.func_130014_f_().func_190527_a(block, blockpos1, true, EnumFacing.UP, null) && !BlockFalling.func_185759_i((IBlockState)this.func_130014_f_().func_180495_p(blockpos1.func_177977_b())) && this.func_130014_f_().func_180501_a(blockpos1, fallblock, 3)) {
                            this.func_70106_y();
                            if (block instanceof BlockFalling) {
                                ((BlockFalling)block).func_176502_a_(this.func_130014_f_(), blockpos1, fallblock, iblockstate);
                            }
                        } else {
                            this.shatter();
                        }
                    }
                }
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i = MathHelper.func_76123_f((float)(distance - 1.0f));
        if (i > 0 && !this.field_70170_p.field_72995_K) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ()));
            for (Entity entity : list) {
                entity.func_70097_a(DamageSource.field_82729_p, 1.0f);
                this.smashOnImpact = true;
            }
        }
    }

    public void shatter() {
        if (!this.func_130014_f_().field_72995_K) {
            this.func_184185_a(this.shatterSound, 0.8f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            IBlockState fallblock = this.func_175131_l();
            if (fallblock != null) {
                this.func_130014_f_().func_175718_b(2001, new BlockPos((Entity)this), Block.func_176210_f((IBlockState)fallblock));
            }
            if (!this.seedStack.func_190926_b()) {
                ItemStack seeds = this.seedStack.func_77946_l();
                seeds.func_190920_e(this.field_70146_Z.nextInt(3) + 1);
                if (this.field_145813_c && this.func_130014_f_().func_82736_K().func_82766_b("doEntityDrops")) {
                    this.func_70099_a(seeds, 0.0f);
                }
            }
            this.func_70106_y();
        }
    }

    @Nullable
    public IBlockState func_175131_l() {
        return Block.func_176220_d((int)((Integer)this.field_70180_af.func_187225_a(FALLBLOCK)));
    }

    public void setBlock(IBlockState blockstate) {
        this.field_70180_af.func_187227_b(FALLBLOCK, (Object)Block.func_176210_f((IBlockState)blockstate));
    }

    public ItemStack getSeedStack() {
        return this.seedStack;
    }

    public void setSeedStack(ItemStack stack) {
        this.seedStack = stack;
    }

    public void setShatterSound(SoundEvent sound) {
        this.shatterSound = sound;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FALLBLOCK, (Object)0);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setBlock(this.field_175132_d);
    }

    public void func_70014_b(NBTTagCompound compound) {
        this.field_175132_d = this.func_175131_l();
        super.func_70014_b(compound);
    }
}

