/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.block.IAdvancedRotationPlacement;
import betterwithmods.api.block.IOverpower;
import betterwithmods.api.block.IRenderRotationPlacement;
import betterwithmods.client.ClientEventHandler;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TileGearbox;
import betterwithmods.util.DirUtils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGearbox
extends BlockRotate
implements IBlockActive,
IOverpower,
IAdvancedRotationPlacement,
IRenderRotationPlacement {
    private final int maxPower;
    private EnumTier type;

    public BlockGearbox(int maxPower, EnumTier type) {
        super(Material.field_151575_d);
        this.maxPower = maxPower;
        this.func_149711_c(2.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.gearbox.name", (Object[])new Object[0]));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getStateForAdvancedRotationPlacement(this.func_176223_P(), placer.func_70093_af() ? side : side.func_176734_d(), flX, flY, flZ);
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177231_a((IProperty)DirUtils.FACING).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, 5, 5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.onChange(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        this.onChange(world, pos);
    }

    public void onChange(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            this.withTile(world, pos).ifPresent(TileGearbox::onChanged);
        }
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return this.getFacingFromState(world.func_180495_p(pos));
    }

    public EnumFacing getFacingFromState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
    }

    private void emitGearboxParticles(World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 5; ++i) {
            float flX = (float)pos.func_177958_n() + rand.nextFloat();
            float flY = (float)pos.func_177956_o() + rand.nextFloat() * 0.5f + 1.0f;
            float flZ = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)flX, (double)flY, (double)flZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            TileGearbox tile;
            this.emitGearboxParticles(world, pos, rand);
            if (rand.nextInt(10) == 0 && (tile = this.getTile(world, pos)) != null && tile.isOverpowered()) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187927_ha, SoundCategory.BLOCKS, 0.25f, world.field_73012_v.nextFloat() * 0.25f + 0.25f, true);
            }
            if (rand.nextInt(50) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.25f, world.field_73012_v.nextFloat() * 0.25f + 0.25f, false);
            }
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean[] dirs = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            dirs[i] = BWMAPI.IMPLEMENTATION.isAxle(world, pos.func_177972_a(facing), facing.func_176734_d()) && this.getFacing(world, pos) != facing;
        }
        return state.func_177226_a((IProperty)DirUtils.DOWN, (Comparable)Boolean.valueOf(dirs[0])).func_177226_a((IProperty)DirUtils.UP, (Comparable)Boolean.valueOf(dirs[1])).func_177226_a((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(dirs[2])).func_177226_a((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(dirs[3])).func_177226_a((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(dirs[4])).func_177226_a((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(dirs[5]));
    }

    public int func_176201_c(IBlockState state) {
        int facing = ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
        int active = this.isActive(state) ? 1 : 0;
        return active | facing << 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)(meta >> 1)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, ACTIVE, DirUtils.UP, DirUtils.DOWN, DirUtils.NORTH, DirUtils.SOUTH, DirUtils.WEST, DirUtils.EAST});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World worldIn, BlockPos pos) {
        return this.isActive(state) ? 15 : 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileGearbox(this.maxPower);
    }

    public Optional<TileGearbox> withTile(World world, BlockPos pos) {
        return Optional.of(this.getTile(world, pos));
    }

    public TileGearbox getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGearbox) {
            return (TileGearbox)tile;
        }
        return null;
    }

    @Override
    public void onChangeActive(World world, BlockPos pos, boolean newValue) {
        if (newValue) {
            world.func_184133_a(null, pos, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.25f);
        }
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        this.overpowerSound(world, pos);
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)DirUtils.FACING);
        Block block = this.type == EnumTier.WOOD ? BWMBlocks.WOODEN_BROKEN_GEARBOX : BWMBlocks.STEEL_BROKEN_GEARBOX;
        world.func_175656_a(pos, block.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing));
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (this.type == EnumTier.STEEL) {
            return 4000.0f;
        }
        return 0.0f;
    }

    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        if (this.type == EnumTier.STEEL) {
            return 100.0f;
        }
        return 3.5f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (this.type == EnumTier.STEEL) {
            return SoundType.field_185852_e;
        }
        return SoundType.field_185848_a;
    }

    public Material func_149688_o(IBlockState state) {
        if (this.type == EnumTier.STEEL) {
            return Material.field_151573_f;
        }
        return Material.field_151575_d;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.type != EnumTier.STEEL || entity instanceof EntityPlayer;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (this.type != EnumTier.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        EnumFacing facing = this.getFacingFromState(state);
        if (facing.func_176740_k().func_176722_c()) {
            return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)rot.func_185831_a(facing));
        }
        return state;
    }

    @Override
    public IBlockState getStateForAdvancedRotationPlacement(IBlockState defaultState, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = defaultState;
        float hitXFromCenter = hitX - 0.5f;
        float hitYFromCenter = hitY - 0.5f;
        float hitZFromCenter = hitZ - 0.5f;
        EnumFacing newFacing = facing;
        switch (facing.func_176740_k()) {
            case Y: {
                if (this.inCenter(hitXFromCenter, hitZFromCenter, 0.0625f)) {
                    newFacing = facing.func_176734_d();
                    break;
                }
                if (this.isMax(hitXFromCenter, hitZFromCenter)) {
                    newFacing = hitXFromCenter > 0.0f ? EnumFacing.EAST : EnumFacing.WEST;
                    break;
                }
                newFacing = hitZFromCenter > 0.0f ? EnumFacing.SOUTH : EnumFacing.NORTH;
                break;
            }
            case X: {
                if (this.inCenter(hitYFromCenter, hitZFromCenter, 0.0625f)) {
                    newFacing = facing.func_176734_d();
                    break;
                }
                if (this.isMax(hitYFromCenter, hitZFromCenter)) {
                    newFacing = hitYFromCenter > 0.0f ? EnumFacing.UP : EnumFacing.DOWN;
                    break;
                }
                newFacing = hitZFromCenter > 0.0f ? EnumFacing.SOUTH : EnumFacing.NORTH;
                break;
            }
            case Z: {
                newFacing = this.inCenter(hitYFromCenter, hitXFromCenter, 0.0625f) ? facing.func_176734_d() : (this.isMax(hitYFromCenter, hitXFromCenter) ? (hitYFromCenter > 0.0f ? EnumFacing.UP : EnumFacing.DOWN) : (hitXFromCenter > 0.0f ? EnumFacing.EAST : EnumFacing.WEST));
            }
        }
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)newFacing);
    }

    @Override
    public AxisAlignedBB getBounds(World world, BlockPos pos, EnumFacing facing, float flX, float flY, float flZ, ItemStack stack, EntityLivingBase placer) {
        return this.getStateForAdvancedRotationPlacement(this.func_176223_P(), facing, flX, flY, flZ).func_185900_c((IBlockAccess)world, pos);
    }

    @Override
    public IRenderRotationPlacement.RenderFunction getRenderFunction() {
        return ClientEventHandler::renderBasicGrid;
    }
}

