/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockAnchor;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRope
extends BWMBlock {
    private static final AxisAlignedBB ROPE_AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);

    public BlockRope() {
        super(Material.field_151594_q);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.5f);
    }

    public static boolean placeRopeUnder(ItemStack stack, World world, BlockPos pos, EntityPlayer player) {
        if (!stack.func_190926_b() || player == null) {
            BlockPos bp = BlockRope.getLowestRopeBlock(world, pos).func_177977_b();
            Block block = world.func_180495_p(bp).func_177230_c();
            if ((world.func_175623_d(bp) || block.func_176200_f((IBlockAccess)world, bp)) && ((BlockRope)BWMBlocks.ROPE.func_176223_P().func_177230_c()).canBlockStay(world, bp)) {
                world.func_175656_a(bp, BWMBlocks.ROPE.func_176223_P());
                world.func_184133_a(null, bp, BWMBlocks.ROPE.getSoundType(BWMBlocks.ROPE.func_176223_P(), world, null, null).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (player != null && !player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    public static BlockPos getLowestRopeBlock(World world, BlockPos pos) {
        if (world != null && pos != null) {
            BlockPos down = pos.func_177977_b();
            Block below = world.func_180495_p(down).func_177230_c();
            if (below == BWMBlocks.ROPE) {
                return BlockRope.getLowestRopeBlock(world, down);
            }
            return pos;
        }
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemBlock && ((ItemBlock)heldItem.func_77973_b()).func_179223_d() == this) {
            return BlockRope.placeRopeUnder(heldItem, worldIn, pos, playerIn);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        Block blockAbove = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        boolean supported = false;
        if (blockAbove == BWMBlocks.ANCHOR) {
            EnumFacing facing = ((BlockAnchor)BWMBlocks.ANCHOR).getFacing(world.func_180495_p(pos.func_177984_a()));
            boolean bl = supported = facing != EnumFacing.UP;
        }
        if (blockAbove == this) {
            supported = true;
        }
        if (blockAbove == BWMBlocks.SINGLE_MACHINES && world.func_180495_p(pos.func_177984_a()).func_177229_b(BlockMechMachines.TYPE) == BlockMechMachines.EnumType.PULLEY) {
            supported = true;
        }
        return supported;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.canBlockStay(world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ROPE_AABB;
    }

    public EnumFacing getFacing(IBlockState state) {
        return null;
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return entity instanceof EntityPlayer;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() != EnumFacing.Axis.Y ? BlockFaceShape.UNDEFINED : BlockFaceShape.CENTER_SMALL;
    }
}

