/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker;

import com.google.common.collect.ImmutableList;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import reborncore.common.util.ItemUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.recipe.Recipes;
import techreborn.compatmod.crafttweaker.CTPraescriptum;
import techreborn.compatmod.crafttweaker.ZenDocumentation;

@ZenClass(value="mods.techreborn.solidCanningMachine")
public class CTSolidCanningMachine
extends CTPraescriptum {
    @ZenMethod
    @ZenDocumentation(value="IItemStack output, IIngredient ingredientA, IIngredient ingredientB, int energyCostPerTick, int operationDuration")
    public static void addRecipe(IItemStack output, IIngredient ingredientA, IIngredient ingredientB, int energyCostPerTick, int operationDuration) {
        ItemStackInputIngredient inputA = ingredientA instanceof IItemStack ? ItemStackInputIngredient.of((ItemStack)ItemUtils.copyWithSize((ItemStack)CraftTweakerMC.getItemStack((IIngredient)ingredientA), (int)ingredientA.getAmount())) : OreDictionaryInputIngredient.of((String)((IOreDictEntry)ingredientA).getName(), (int)ingredientA.getAmount());
        ItemStackInputIngredient inputB = ingredientB instanceof IItemStack ? ItemStackInputIngredient.of((ItemStack)ItemUtils.copyWithSize((ItemStack)CraftTweakerMC.getItemStack((IIngredient)ingredientB), (int)ingredientB.getAmount())) : OreDictionaryInputIngredient.of((String)((IOreDictEntry)ingredientB).getName(), (int)ingredientB.getAmount());
        Recipe recipe = CTSolidCanningMachine.getRecipeHandler().createRecipe().withInput((List)ImmutableList.of((Object)inputA, (Object)inputB)).withOutput(CraftTweakerMC.getItemStack((IItemStack)output)).withEnergyCostPerTick(energyCostPerTick).withOperationDuration(operationDuration);
        CTSolidCanningMachine.add(recipe);
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack ingredientA, IItemStack ingredientB")
    public static void removeRecipe(IItemStack ingredientA, IItemStack ingredientB) {
        ItemStack inputA = CraftTweakerMC.getItemStack((IItemStack)ingredientA);
        ItemStack inputB = CraftTweakerMC.getItemStack((IItemStack)ingredientB);
        Optional maybeRecipe = CTSolidCanningMachine.getRecipeHandler().findRecipe(ImmutableList.of((Object)inputA, (Object)inputB), ImmutableList.of());
        maybeRecipe.ifPresent(recipe -> CTSolidCanningMachine.getRecipeHandler().removeRecipe(recipe));
    }

    @ZenMethod
    public static void removeAll() {
        CTSolidCanningMachine.removeAll(CTSolidCanningMachine.getRecipeHandler());
    }

    public static RecipeHandler getRecipeHandler() {
        return Recipes.solidCanningMachine;
    }
}

