/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.crafttweaker;

import com.google.common.collect.ImmutableList;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import reborncore.api.praescriptum.recipes.Recipe;
import reborncore.api.praescriptum.recipes.RecipeHandler;
import reborncore.common.util.ItemUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.recipe.Recipes;
import techreborn.compatmod.crafttweaker.CTPraescriptum;
import techreborn.compatmod.crafttweaker.ZenDocumentation;

@ZenClass(value="mods.techreborn.extractor")
public class CTExtractor
extends CTPraescriptum {
    @ZenMethod
    @ZenDocumentation(value="IItemStack output, IIngredient ingredient, int energyCostPerTick, int operationDuration")
    public static void add(IItemStack output, IIngredient ingredient, int energyCostPerTick, int operationDuration) {
        ItemStackInputIngredient input = ingredient instanceof IItemStack ? ItemStackInputIngredient.of((ItemStack)ItemUtils.copyWithSize((ItemStack)CraftTweakerMC.getItemStack((IIngredient)ingredient), (int)ingredient.getAmount())) : OreDictionaryInputIngredient.of((String)((IOreDictEntry)ingredient).getName(), (int)ingredient.getAmount());
        Recipe recipe = CTExtractor.getRecipeHandler().createRecipe().withInput((List)ImmutableList.of((Object)input)).withOutput(CraftTweakerMC.getItemStack((IItemStack)output)).withEnergyCostPerTick(energyCostPerTick).withOperationDuration(operationDuration);
        CTExtractor.add(recipe);
    }

    @ZenMethod
    @ZenDocumentation(value="IItemStack ingredient")
    public static void remove(IItemStack ingredient) {
        ItemStack input = CraftTweakerMC.getItemStack((IItemStack)ingredient);
        Optional maybeRecipe = CTExtractor.getRecipeHandler().findRecipe(ImmutableList.of((Object)input), ImmutableList.of());
        maybeRecipe.ifPresent(recipe -> CTExtractor.getRecipeHandler().removeRecipe(recipe));
    }

    @ZenMethod
    public static void removeAll() {
        CTExtractor.removeAll(CTExtractor.getRecipeHandler());
    }

    public static RecipeHandler getRecipeHandler() {
        return Recipes.extractor;
    }
}

