/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.item.ItemEntry;
import com.feed_the_beast.ftblib.lib.item.ItemEntryWithCount;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.item.ItemLootCrate;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileLootCrateOpener
extends TileBase
implements IItemHandler {
    public List<ItemEntryWithCount> items = new ArrayList<ItemEntryWithCount>();
    public UUID owner = null;

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (!type.save) {
            return;
        }
        NBTTagList itemsTag = new NBTTagList();
        for (ItemEntryWithCount entry : this.items) {
            if (entry.isEmpty()) continue;
            itemsTag.func_74742_a((NBTBase)entry.serializeNBT());
        }
        nbt.func_74782_a("items", (NBTBase)itemsTag);
        if (this.owner != null && !type.item) {
            nbt.func_74778_a("owner", StringUtils.fromUUID((UUID)this.owner));
        }
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        if (!type.save) {
            return;
        }
        NBTTagList itemsTag = nbt.func_150295_c("items", 10);
        this.items = new ArrayList<ItemEntryWithCount>(itemsTag.func_74745_c());
        for (int i = 0; i < itemsTag.func_74745_c(); ++i) {
            ItemEntryWithCount entry = new ItemEntryWithCount(itemsTag.func_179238_g(i));
            if (entry.isEmpty()) continue;
            this.items.add(entry);
        }
        this.owner = nbt.func_74764_b("owner") ? StringUtils.fromString((String)nbt.func_74779_i("owner")) : null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : super.getCapability(capability, facing));
    }

    public int getSlots() {
        return 2;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot == 0 || this.items.isEmpty() ? ItemStack.field_190927_a : this.items.get(0).getStack(false);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0) {
            return stack;
        }
        LootCrate crate = ItemLootCrate.getCrate(this.field_145850_b, stack);
        if (crate == null) {
            return stack;
        }
        if (!simulate && !this.field_145850_b.field_72995_K) {
            EntityPlayerMP player;
            int totalWeight = crate.table.getTotalWeight(true);
            EntityPlayerMP entityPlayerMP = player = this.owner == null ? null : this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(this.owner);
            if (totalWeight > 0) {
                block0: for (int j = 0; j < stack.func_190916_E() * crate.table.lootSize; ++j) {
                    int currentWeight = crate.table.emptyWeight;
                    int number = this.field_145850_b.field_73012_v.nextInt(totalWeight) + 1;
                    if (currentWeight >= number) continue;
                    for (WeightedReward reward : crate.table.rewards) {
                        if ((currentWeight += reward.weight) < number) continue;
                        ItemStack stack1 = reward.reward.claimAutomated((TileEntity)this, player);
                        if (stack1.func_190926_b()) continue block0;
                        this.insertItem(stack1);
                        continue block0;
                    }
                }
            }
            this.func_70296_d();
        }
        return ItemStack.field_190927_a;
    }

    private void insertItem(ItemStack stack) {
        ItemEntry entry = ItemEntry.get((ItemStack)stack);
        for (ItemEntryWithCount entry1 : this.items) {
            if (!entry1.entry.equalsEntry(entry)) continue;
            entry1.count += stack.func_190916_E();
            return;
        }
        this.items.add(new ItemEntryWithCount(entry, stack.func_190916_E()));
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && ItemLootCrate.getCrate(this.field_145850_b, stack) != null;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0 || amount <= 0 || this.items.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemEntryWithCount entry = this.items.get(0);
        ItemStack stack1 = entry.getStack(true);
        int a = Math.min(entry.count, Math.min(amount, stack1.func_77976_d()));
        stack1.func_190920_e(a);
        if (!simulate && !this.field_145850_b.field_72995_K) {
            entry.count -= a;
            if (entry.isEmpty()) {
                this.items.remove(0);
            }
            this.func_70296_d();
        }
        return stack1;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void func_70296_d() {
        this.sendDirtyUpdate();
    }
}

