/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.customnpcs;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigList;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.integration.customnpcs.CustomNPCsIntegration;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.PlayerMail;

public class NPCMailReward
extends Reward {
    public final PlayerMail mail = new PlayerMail();

    public NPCMailReward(Quest quest) {
        super(quest);
        this.mail.sender = "Unknown Sender";
        this.mail.subject = "Unknown Subject";
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagString("No text!"));
        this.mail.message.func_74782_a("pages", (NBTBase)list);
    }

    @Override
    public RewardType getType() {
        return CustomNPCsIntegration.MAIL_REWARD;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74782_a("mail", (NBTBase)this.mail.writeNBT());
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.mail.readNBT(nbt.func_74775_l("mail"));
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeNBT(this.mail.writeNBT());
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.mail.readNBT(data.readNBT());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("subject", () -> this.mail.subject, v -> {
            this.mail.subject = v;
        }, "");
        config.addString("sender", () -> this.mail.sender, v -> {
            this.mail.sender = v;
        }, "");
        config.add("message", (ConfigValue)new ConfigList<ConfigString>(new ConfigString("")){

            public void readFromList() {
                NBTTagList pages = new NBTTagList();
                for (ConfigString string : this.list) {
                    pages.func_74742_a((NBTBase)new NBTTagString(string.getString()));
                }
                NPCMailReward.this.mail.message.func_74782_a("pages", (NBTBase)pages);
            }

            public void writeToList() {
                this.list.clear();
                NBTTagList pages = NPCMailReward.this.mail.message.func_150295_c("pages", 8);
                for (int i = 0; i < pages.func_74745_c(); ++i) {
                    this.list.add(new ConfigString(pages.func_150307_f(i)));
                }
            }
        }, (ConfigValue)new ConfigList((ConfigValue)new ConfigString("")));
        config.addInt("quest_id", () -> this.mail.questId, v -> {
            this.mail.questId = v;
        }, -1, -1, Integer.MAX_VALUE);
        config.addList("items", (Collection)this.mail.items, (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a), ConfigItemStack::new, ConfigItemStack::getStack);
    }

    @Override
    public void claim(EntityPlayerMP player, boolean notify) {
        if (this.mail.isValid()) {
            PlayerDataController.instance.addPlayerMessage(player.field_71133_b, player.func_70005_c_(), this.mail.copy());
        }
    }
}

