/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.chest;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.chest.GuiQuestChest;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonTask
extends Button {
    private final TaskData taskData;

    public ButtonTask(Panel panel, TaskData d) {
        super(panel);
        this.taskData = d;
        this.setSize(panel.width, 8);
    }

    public void addMouseOverText(List<String> list) {
        if (((Task)this.taskData.task).quest.chapter.file.chapters.size() > 1) {
            list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.chapter", (Object[])new Object[0]) + ": " + ((Task)this.taskData.task).quest.chapter.getYellowDisplayName());
        }
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.quest", (Object[])new Object[0]) + ": " + ((Task)this.taskData.task).quest.getYellowDisplayName());
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.progress", (Object[])new Object[0]) + ": " + TextFormatting.BLUE + this.taskData.getProgressString() + " / " + ((Task)this.taskData.task).getMaxProgressString());
    }

    public void onClicked(MouseButton button) {
        ((Task)this.taskData.task).onButtonClicked(true);
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        int r = (int)((long)(this.taskData.getRelativeProgress() * this.width) / 100L);
        if ((long)r > 0L) {
            GuiQuestChest.TEXTURE.withUV(0.0, r >= this.width ? 199.0 : 190.0, (double)r, 8.0, 256.0, 256.0).draw(x, y, r, 8);
        }
        ((QuestObjectBase)this.taskData.task).getIcon().draw(x + 1, y, 8, 8);
        theme.drawString(((QuestObjectBase)this.taskData.task).getTitle(), x + 11, y, theme.getContentColor(this.getWidgetType()), 2);
    }

    @Nullable
    public Object getIngredientUnderMouse() {
        return ((Task)this.taskData.task).getIngredient();
    }
}

