/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.mining;

import java.util.Random;
import levelup2.config.LevelUpConfig;
import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StoneMiningBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:prospecting";
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @Override
    public byte getSkillType() {
        return 0;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Blocks.field_150352_o);
    }

    @SubscribeEvent
    public void onHarvest(BlockEvent.HarvestDropsEvent evt) {
        if (!this.isActive()) {
            return;
        }
        if (evt.getHarvester() != null && !evt.getWorld().field_72995_K) {
            int skill = SkillRegistry.getSkillLevel(evt.getHarvester(), this.getSkillName());
            IBlockState state = evt.getState();
            Random rand = evt.getHarvester().func_70681_au();
            this.dropOreChunks(evt, skill, state, rand);
        }
    }

    @SubscribeEvent
    public void stopPlacingDupes(PlayerInteractEvent.RightClickBlock evt) {
        ItemStack stack = evt.getItemStack();
        if (!stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("NoPlace") && Library.isOre(stack)) {
            evt.setUseItem(Event.Result.DENY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addTooltip(ItemTooltipEvent evt) {
        ItemStack stack = evt.getItemStack();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("NoPlace")) {
            evt.getToolTip().add(I18n.func_135052_a((String)"flag.noplace", (Object[])new Object[0]));
        }
    }

    private void dropOreChunks(BlockEvent.HarvestDropsEvent evt, int skill, IBlockState state, Random rand) {
        if (!Library.getOreList().isEmpty() && Library.getOreList().contains(state.func_177230_c())) {
            if (rand.nextDouble() <= (double)skill / 20.0) {
                int quantity;
                Item item;
                int fortuneBonus = LevelUpConfig.fortuneOre && evt.getFortuneLevel() > 0 ? rand.nextInt(evt.getFortuneLevel() + 1) : 0;
                boolean foundBlock = false;
                for (ItemStack stack : evt.getDrops()) {
                    ItemStack replace;
                    if (stack.func_190926_b() || state.func_177230_c() != Block.func_149634_a((Item)stack.func_77973_b()) && !Library.isOre(stack) || (replace = this.getReplacementStack(stack, true, fortuneBonus)).func_190926_b()) continue;
                    Library.removeFromList(evt.getDrops(), stack);
                    evt.getDrops().add(replace);
                    foundBlock = true;
                    break;
                }
                if (!foundBlock && (item = state.func_177230_c().func_180660_a(state, rand, evt.getFortuneLevel())) != null && (quantity = state.func_177230_c().quantityDropped(state, evt.getFortuneLevel(), rand)) > 0) {
                    evt.getDrops().add(new ItemStack(item, quantity, state.func_177230_c().func_180651_a(state)));
                }
            } else if (LevelUpConfig.useOreChunks && LevelUpConfig.alwaysDropChunks) {
                for (ItemStack stack : evt.getDrops()) {
                    ItemStack replace;
                    if (stack.func_190926_b() || state.func_177230_c() != Block.func_149634_a((Item)stack.func_77973_b()) || (replace = this.getReplacementStack(stack, false, 0)).func_190926_b() || replace.func_77969_a(stack)) continue;
                    Library.removeFromList(evt.getDrops(), stack);
                    replace.func_190920_e(1);
                    evt.getDrops().add(replace);
                }
            }
        }
    }

    private ItemStack getReplacementStack(ItemStack stack, boolean duplication, int fortune) {
        ItemStack replace;
        ItemStack itemStack = replace = LevelUpConfig.useOreChunks ? Library.getChunkFromName(Library.getOreNameForBlock(stack), fortune) : this.getDupeStack(stack, duplication, fortune);
        if (LevelUpConfig.useOreChunks && replace.func_190926_b()) {
            replace = this.getDupeStack(stack, duplication, fortune);
        }
        return replace;
    }

    private ItemStack getDupeStack(ItemStack stack, boolean duplication, int fortune) {
        if (Library.isOre(stack)) {
            ItemStack dupe = stack.func_77946_l();
            dupe.func_190917_f(stack.func_190916_E());
            if (duplication) {
                dupe.func_190917_f(fortune);
                if (stack.func_77973_b() instanceof ItemBlock) {
                    this.attachNoPlacement(dupe);
                }
            }
            return dupe;
        }
        return ItemStack.field_190927_a;
    }

    private void attachNoPlacement(ItemStack stack) {
        NBTTagCompound tag;
        NBTTagCompound nBTTagCompound = tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (tag != null) {
            tag.func_74757_a("NoPlace", true);
            stack.func_77982_d(tag);
        }
    }
}

