/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Items;

import com.wuest.repurpose.Capabilities.ItemBagOfHoldingProvider;
import com.wuest.repurpose.ModRegistry;
import com.wuest.repurpose.Repurpose;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBagOfHolding
extends Item {
    public static final String customValues = "bag_values";
    public static final String currentSlotName = "current_slot";
    public static final String bagOpenName = "bag_opened";

    public ItemBagOfHolding(String name) {
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
        ModRegistry.setItemName(this, name);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && hand == EnumHand.OFF_HAND) {
            int slot;
            ItemStack stackInSlot;
            BlockPos newBlockPos;
            ItemBagOfHoldingProvider handler;
            ItemStack stack = player.func_184586_b(hand);
            if (player.func_70093_af()) {
                ItemBagOfHolding.setBagOpenedStack(stack, !ItemBagOfHolding.getBagOpenedFromStack(stack));
                player.field_71069_bz.func_75142_b();
                int test = stack.func_77960_j();
                return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
            }
            RayTraceResult result = ItemBagOfHolding.rayTrace(player, 5.0, 1.0f);
            if (result.field_72313_a == RayTraceResult.Type.MISS) {
                player.openGui((Object)Repurpose.instance, 8, world, player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
            } else if (result.field_72313_a == RayTraceResult.Type.BLOCK && (handler = ItemBagOfHoldingProvider.GetFromStack(stack)) != null && world.func_175623_d(newBlockPos = result.func_178782_a().func_177972_a(result.field_178784_b)) && (stackInSlot = handler.extractItem(slot = ItemBagOfHolding.getCurrentSlotFromStack(stack), 1, false)).func_77973_b() instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)stackInSlot.func_77973_b();
                EnumActionResult placementResult = this.PlaceBlockFromPouch(player, world, itemBlock, result, newBlockPos, stackInSlot);
                if (placementResult == EnumActionResult.SUCCESS) {
                    stackInSlot.func_190918_g(1);
                    handler.UpdateStack(stack);
                } else {
                    handler.insertItem(slot, stackInSlot, false);
                    handler.UpdateStack(stack);
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public int getMetadata(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(stack.serializeNBT());
        }
        return stack.func_77952_i();
    }

    public String func_77667_c(ItemStack stack) {
        String returnValue = super.func_77658_a();
        boolean bagIsOpen = ItemBagOfHolding.getBagOpenedFromStack(stack);
        return returnValue + (bagIsOpen ? "_opened" : "_closed");
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(stack.serializeNBT());
        }
        return stack.func_77978_p();
    }

    public EnumActionResult PlaceBlockFromPouch(EntityPlayer player, World world, ItemBlock itemBlock, RayTraceResult rayTraceResult, BlockPos pos, ItemStack itemStack) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(rayTraceResult.field_178784_b);
        }
        if (player.func_175151_a(pos, rayTraceResult.field_178784_b, itemStack) && world.func_190527_a(itemBlock.func_179223_d(), pos, false, rayTraceResult.field_178784_b, (Entity)null)) {
            int metaData = itemBlock.func_77647_b(itemStack.func_77960_j());
            IBlockState placementState = itemBlock.func_179223_d().getStateForPlacement(world, pos, rayTraceResult.field_178784_b, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), metaData, (EntityLivingBase)player, EnumHand.OFF_HAND);
            if (itemBlock.placeBlockAt(itemStack, player, world, pos, rayTraceResult.field_178784_b, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p(), placementState)) {
                placementState = world.func_180495_p(pos);
                SoundType soundType = placementState.func_177230_c().getSoundType(placementState, world, pos, (Entity)player);
                world.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        Minecraft minecraft = Minecraft.func_71410_x();
        boolean advancedKeyDown = minecraft.field_71462_r.func_146272_n();
        if (!advancedKeyDown) {
            tooltip.add("Hold" + TextFormatting.BLUE + " Shift " + TextFormatting.GRAY + "for advanced information.");
        } else {
            tooltip.add("Place in off-hand and right-click to open inventory or place block. Sneak and right-click when in off-hand to open/close bag.");
        }
    }

    public static void RefreshItemStack(EntityPlayer player, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBagOfHolding && !player.field_70170_p.field_72995_K) {
            ItemBagOfHoldingProvider.UpdateRefreshValue(stack);
        }
    }

    @Nullable
    public static RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public static int getCurrentSlotFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBagOfHolding) {
            ItemBagOfHoldingProvider handler = ItemBagOfHoldingProvider.GetFromStack(stack);
            return handler.slotIndex;
        }
        return 0;
    }

    public static void setCurrentSlotForStack(EntityPlayer player, ItemStack stack, int slot) {
        if (stack.func_77973_b() instanceof ItemBagOfHolding) {
            ItemBagOfHoldingProvider handler = ItemBagOfHoldingProvider.GetFromStack(stack);
            handler.slotIndex = slot;
            handler.UpdateStack(stack);
        }
    }

    public static boolean getBagOpenedFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBagOfHolding) {
            ItemBagOfHoldingProvider handler = ItemBagOfHoldingProvider.GetFromStack(stack);
            return handler.opened;
        }
        return false;
    }

    public static void setBagOpenedStack(ItemStack stack, boolean open) {
        if (stack.func_77973_b() instanceof ItemBagOfHolding) {
            ItemBagOfHoldingProvider handler = ItemBagOfHoldingProvider.GetFromStack(stack);
            handler.opened = open;
            handler.UpdateStack(stack);
            int metaValue = open ? 1 : 0;
            stack.func_77964_b(metaValue);
        }
    }

    public static ItemStack getItemStackFromInventory(EntityPlayer player) {
        ItemStack stack = player.func_184592_cb();
        if (stack.func_77973_b() instanceof ItemBagOfHolding) {
            int slot = ItemBagOfHolding.getCurrentSlotFromStack(stack);
            ItemBagOfHoldingProvider handler = ItemBagOfHoldingProvider.GetFromStack(stack);
            if (handler != null) {
                if (slot >= handler.getSlots()) {
                    slot = 0;
                }
                return handler.getStackInSlot(slot);
            }
        }
        return ItemStack.field_190927_a;
    }
}

