/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.repurpose.Blocks;

import com.wuest.repurpose.Gui.CustomSlot;
import com.wuest.repurpose.ModRegistry;
import com.wuest.repurpose.Repurpose;
import com.wuest.repurpose.Tiles.TileEntityCoffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCoffer
extends Block {
    public static final PropertyEnum<IronChestType> VARIANT_PROP = PropertyEnum.func_177709_a((String)"variant", IronChestType.class);
    protected static final AxisAlignedBB IRON_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private static final EnumFacing[] validRotationAxes = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};

    public BlockCoffer() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT_PROP, (Comparable)((Object)IronChestType.IRON)));
        this.func_149711_c(3.0f);
        this.func_149647_a(CreativeTabs.field_78030_b);
        ModRegistry.setBlockName(this, "block_coffer");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return IRON_CHEST_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public ILockableContainer getLockableContainer(World worldIn, BlockPos pos) {
        return this.getContainer(worldIn, pos, false);
    }

    @Nullable
    public ILockableContainer getContainer(World worldIn, BlockPos pos, boolean allowBlocking) {
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing heldItem, float side, float hitX, float hitY) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityCoffer)) {
            return true;
        }
        if (worldIn.isSideSolid(pos.func_177982_a(0, 1, 0), EnumFacing.DOWN)) {
            return true;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        playerIn.openGui((Object)Repurpose.instance, 7, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((IronChestType)((Object)state.func_177229_b(VARIANT_PROP))).makeEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (IronChestType type : IronChestType.VALUES) {
            if (!type.isValidForCreativeMode()) continue;
            list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT_PROP, (Comparable)((Object)IronChestType.VALUES[meta]));
    }

    public int func_176201_c(IBlockState blockState) {
        return ((IronChestType)((Object)blockState.func_177229_b(VARIANT_PROP))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT_PROP});
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_184138_a(pos, state, state, 3);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCoffer) {
            TileEntityCoffer teic = (TileEntityCoffer)te;
            teic.wasPlaced(placer, stack);
            teic.setFacing(placer.func_174811_aO().func_176734_d());
            worldIn.func_184138_a(pos, state, state, 3);
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((IronChestType)((Object)state.func_177229_b(VARIANT_PROP))).ordinal();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityCoffer tileentity = (TileEntityCoffer)worldIn.func_175625_s(pos);
        if (tileentity != null) {
            tileentity.removeAdornments();
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tileentity);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntityCoffer teic;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCoffer && (teic = (TileEntityCoffer)te).getType().isExplosionResistant()) {
            return 10000.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public EnumFacing[] getValidRotations(World worldObj, BlockPos pos) {
        return validRotationAxes;
    }

    public boolean rotateBlock(World worldObj, BlockPos pos, EnumFacing axis) {
        if (worldObj.field_72995_K) {
            return false;
        }
        if (axis == EnumFacing.UP || axis == EnumFacing.DOWN) {
            TileEntity tileEntity = worldObj.func_175625_s(pos);
            if (tileEntity instanceof TileEntityCoffer) {
                TileEntityCoffer icte = (TileEntityCoffer)tileEntity;
                icte.rotateAround();
            }
            return true;
        }
        return false;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public static enum IronChestType implements IStringSerializable
    {
        IRON(90, 9, true, "block_coffer.png", Arrays.asList("ingotIron", "ingotRefinedIron"), TileEntityCoffer.class, 184, 202);

        public static final IronChestType[] VALUES;
        public final String name = this.name().toLowerCase();
        public final int size;
        public final int rowLength;
        public final boolean tieredChest;
        public final ResourceLocation modelTexture;
        public final Class<? extends TileEntityCoffer> clazz;
        public final Collection<String> matList;
        public final int xSize;
        public final int ySize;

        private IronChestType(int size, int rowLength, boolean tieredChest, String modelTexture, Collection<String> mats, Class<? extends TileEntityCoffer> clazz, int xSize, int ySize) {
            this.size = size;
            this.rowLength = rowLength;
            this.tieredChest = tieredChest;
            this.modelTexture = new ResourceLocation("repurpose", "textures/blocks/" + modelTexture);
            this.matList = Collections.unmodifiableCollection(mats);
            this.clazz = clazz;
            this.xSize = xSize;
            this.ySize = ySize;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getRowCount() {
            return this.size / this.rowLength;
        }

        public boolean isTransparent() {
            return false;
        }

        public boolean isValidForCreativeMode() {
            return true;
        }

        public boolean isExplosionResistant() {
            return false;
        }

        public CustomSlot makeSlot(IInventory chestInventory, int index, int x, int y) {
            return new CustomSlot(chestInventory, index, x, y);
        }

        public boolean acceptsStack(ItemStack itemstack) {
            return true;
        }

        public TileEntityCoffer makeEntity() {
            switch (this) {
                case IRON: {
                    return new TileEntityCoffer();
                }
            }
            return null;
        }

        static {
            VALUES = IronChestType.values();
        }
    }
}

