/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import com.electronwill.nightconfig.core.Config;
import logictechcorp.libraryex.utility.ConfigHelper;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BiomeTraitAbstractTree
extends BiomeTrait {
    protected IBlockState logBlock;
    protected IBlockState leafBlock;
    protected IBlockState blockToTarget;
    protected int minimumGrowthHeight;
    protected int maximumGrowthHeight;

    protected BiomeTraitAbstractTree(Builder builder) {
        super(builder);
        this.logBlock = builder.logBlock;
        this.leafBlock = builder.leafBlock;
        this.blockToTarget = builder.blockToTarget;
        this.minimumGrowthHeight = builder.minimumGrowthHeight;
        this.maximumGrowthHeight = builder.maximumGrowthHeight;
    }

    @Override
    public void readFromConfig(Config config) {
        super.readFromConfig(config);
        this.logBlock = ConfigHelper.getBlockState(config, "logBlock");
        this.leafBlock = ConfigHelper.getBlockState(config, "leafBlock");
        this.blockToTarget = ConfigHelper.getBlockState(config, "blockToTarget");
        this.minimumGrowthHeight = (Integer)config.getOrElse("minimumGrowthHeight", (Object)2);
        this.maximumGrowthHeight = (Integer)config.getOrElse("maximumGrowthHeight", (Object)32);
    }

    @Override
    public void writeToConfig(Config config) {
        super.writeToConfig(config);
        ConfigHelper.setBlockState(config, "logBlock", this.logBlock);
        ConfigHelper.setBlockState(config, "leafBlock", this.leafBlock);
        ConfigHelper.setBlockState(config, "blockToTarget", this.blockToTarget);
        config.add("minimumGrowthHeight", (Object)this.minimumGrowthHeight);
        config.add("maximumGrowthHeight", (Object)this.maximumGrowthHeight);
    }

    protected void placeLogAt(World world, BlockPos pos) {
        if (this.canGrowInto(world.func_180495_p(pos).func_177230_c())) {
            world.func_175656_a(pos, this.logBlock);
        }
    }

    protected boolean canGrowInto(Block block) {
        Material material = block.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151584_j;
    }

    protected boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos) || this.canGrowInto(state.func_177230_c());
    }

    public static abstract class Builder
    extends BiomeTrait.Builder {
        protected IBlockState logBlock = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
        protected IBlockState leafBlock = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK);
        protected IBlockState blockToTarget = Blocks.field_150349_c.func_176223_P();
        protected int minimumGrowthHeight = 4;
        protected int maximumGrowthHeight = 6;

        public Builder logBlock(IBlockState logBlock) {
            this.logBlock = logBlock;
            return this;
        }

        public Builder leafBlock(IBlockState leafBlock) {
            this.leafBlock = leafBlock;
            return this;
        }

        public Builder blockToTarget(IBlockState blockToTarget) {
            this.blockToTarget = blockToTarget;
            return this;
        }

        public Builder minimumGrowthHeight(int minimumGrowthHeight) {
            this.minimumGrowthHeight = minimumGrowthHeight;
            return this;
        }

        public Builder maximumGrowthHeight(int maximumGrowthHeight) {
            this.maximumGrowthHeight = maximumGrowthHeight;
            return this;
        }

        @Override
        public abstract BiomeTrait create();
    }
}

