/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.util;

import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PositionUtils {
    public static BlockPos getMinCorner(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static BlockPos getMaxCorner(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), Math.max(pos1.func_177956_o(), pos2.func_177956_o()), Math.max(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static BlockPos getRelativeEndPositionFromAreaSize(BlockPos size) {
        int x = size.func_177958_n();
        int y = size.func_177956_o();
        int z = size.func_177952_p();
        x = x >= 0 ? x - 1 : x + 1;
        y = y >= 0 ? y - 1 : y + 1;
        z = z >= 0 ? z - 1 : z + 1;
        return new BlockPos(x, y, z);
    }

    public static Vec3d getTransformedPosition(Vec3d originalPos, Mirror mirror, Rotation rotation) {
        double x = originalPos.field_72450_a;
        double y = originalPos.field_72448_b;
        double z = originalPos.field_72449_c;
        boolean transformed = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                z = 1.0 - z;
                break;
            }
            case FRONT_BACK: {
                x = 1.0 - x;
                break;
            }
            default: {
                transformed = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(z, y, 1.0 - x);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - z, y, x);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - x, y, 1.0 - z);
            }
        }
        return transformed ? new Vec3d(x, y, z) : originalPos;
    }
}

