/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.worldprimer.config;

import fi.dy.masa.worldprimer.util.TimedCommands;
import java.io.File;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Configs {
    static File configurationFile;
    static Configuration config;
    public static final String CATEGORY_COMMANDS = "Commands";
    public static final String CATEGORY_GENERIC = "Generic";
    public static final String CATEGORY_TOGGLES = "Toggles";
    public static boolean enableLoggingInfo;
    public static boolean enableDataTracking;
    public static boolean enableChiselsAndBitsCrossWorldFormat;
    public static boolean enableDimensionLoadingCommands;
    public static boolean enableEarlyWorldCreationCommands;
    public static boolean enableEarlyWorldLoadingCommands;
    public static boolean enablePostWorldCreationCommands;
    public static boolean enablePostWorldLoadingCommands;
    public static boolean enableTimedCommands;
    public static boolean enablePlayerDeathCommands;
    public static boolean enablePlayerChangedDimensionEnterCommands;
    public static boolean enablePlayerChangedDimensionLeaveCommands;
    public static boolean enablePlayerJoinCommands;
    public static boolean enablePlayerQuitCommands;
    public static boolean enablePlayerRespawnCommands;
    public static String commandSenderName;
    public static String[] dimensionLoadingCommands;
    public static String[] earlyWorldCreationCommands;
    public static String[] earlyWorldLoadingCommands;
    public static String[] postWorldCreationCommands;
    public static String[] postWorldLoadingCommands;
    public static String[] timedCommands;
    public static String[] playerDeathCommands;
    public static String[] playerChangedDimensionEnterCommands;
    public static String[] playerChangedDimensionLeaveCommands;
    public static String[] playerJoinCommands;
    public static String[] playerQuitCommands;
    public static String[] playerRespawnCommands;

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("worldprimer".equals(event.getModID())) {
            Configs.loadConfigs(config);
        }
    }

    public static void loadConfigsFromFile(File configFile) {
        configurationFile = configFile;
        Configs.loadConfigsFromFile();
    }

    public static void loadConfigsFromFile() {
        config = new Configuration(configurationFile, null, true);
        config.load();
        Configs.loadConfigs(config);
    }

    private static void loadConfigs(Configuration conf) {
        ConfigCategory category = conf.getCategory(CATEGORY_COMMANDS);
        category.setComment("Command documentation:\nThere are a few substitutions available to use in the commands:\nBasic number substitutions from world data:\n{DIMENSION}\n{SPAWN_X}\n{SPAWN_Y}\n{SPAWN_Z}.\n\nAlso {SPAWN_POINT_X} etc. that return the spawn point instead of the possible spawn coordinate (like in the End).\nAny occurences of those strings will be replaced by the current dimension ID,\nor the coordinates of the spawn point respectively.\n\nRandom numbers, integer and double type: {RAND:min,max},\nfor example {RAND:5,15} or {RAND:1.2,3.9} (the max value is exclusive)\n\nReal time/clock values:\n\t{TIME_Y} => year   (4 digits: 2017)\n\t{TIME_M} => month  (2 digits: 03)\n\t{TIME_D} => day    (2 digits: 04)\n\t{TIME_H} => hour   (2 digits: 09)\n\t{TIME_I} => minute (2 digits: 05)\n\t{TIME_S} => second (2 digits: 07)\n\t{TIME_TICK} => current world total time in ticks\n\t{TIME_TICK_DAY} => current world/day time in ticks\n\nThe y-coordinate of the top-most block in the world in the given coordinates\n(actually the air block above it): {TOP_Y:x,z} for example: {TOP_Y:-37,538}\n\nThe x y z coordinates of the top-most block in the world in a random location around a given x,z location\n(again, actually the air block above it): {TOP_Y_RAND:x,z;x-range,z-range}\nfor example: {TOP_Y_RAND:-37,538;32,32} would be the top block at a random location within\n32 blocks of x = -37, z = 538. That substitution will be replaced with a string like '-49 72 544' (without the quotes)\n\nFor the player-specific commands, the following substitutions are available:\n{PLAYER_X}, {PLAYER_Y}, {PLAYER_Z} and {PLAYER_NAME}\n\nAlso {PLAYER_BED_X}, {PLAYER_BED_Y} and {PLAYER_BED_Z} for the last set (bed) spawn point.\nThere are also {PLAYER_BED_SPAWN_X}, {PLAYER_BED_SPAWN_Y} and {PLAYER_BED_SPAWN_Z} that also check that the bed exists,\nor otherwise they will revert to the fallback world spawn point.\nNote that these will thus load that one chunk to check for the bed.\n\nThe player-specific commands can be targeted to specific counts (like the 6th respawn for example)\nor a multiple of a count (similarly to the dim-loading-command prefix)\nby prefixing the command like so: 'worldprimer-tracked-command-nth <count> <actual command>'\nFor example in the playerRespawnCommands:\nworldprimer-tracked-command-nth 3 say The player {PLAYER_NAME} has respawned for the third time at {PLAYER_X}, {PLAYER_Y}, {PLAYER_Z}\nworldprimer-tracked-command-nth %5 say The player {PLAYER_NAME} has respawned for some multiple of 5 times\n\nNote that the above only applies to the other player-specific commands, but not the playerChangedDimension commands.\nFor the playerChangedDimension commands, the same format works instead as for the dimension loading commands:\nworldprimer-dim-command-nth 3 1 say The player {PLAYER_NAME} has entered The End (dimension {DIMENSION}) for the third time\n\nThe substitutions also support very basic arithmetic operations [+-*/].\nSo you can do for example:\nfill {SPAWN_X}-2 {SPAWN_Y}+3 {SPAWN_Z}-2 {SPAWN_X}+2 {SPAWN_Y}+7 {SPAWN_Z}+2 minecraft:emerald_block\n\nNote however that there is no actual order of operations/priorities/grouping.\nThe commands are parsed/substituted from the left, and if there is an arithmetic\noperation immediately following the closing curly brace of a substitution, then the value\nof the following string interpreted as a number is added to the substituted value.\nThat string following the arithmetic operation is first substituted recursively though,\nwhich means that the order of operations is actually starting from the right.\n\nBoth the substitutions and the arithmetic operations following them can be escaped by a preceding backslash '\\',\nif it should actually appear in the command as-is and not be substituted.\nFor example: 'say Foo bar \\{SPANW_X}' would become 'say Foo bar {SPANW_X}' in the final command.\nOr 'say Foo bar {SPAWN_X}\\+16' would become 'say Foo bar 34+16', assuming the spawn x-coordinate is 34.\n\nNote, that the earlyWorldCreationCommands and the earlyWorldLoadingCommands\nDO NOT have a world available yet, so the substitutions will NOT happen for those commands.\nThus, those commands also can't do anything that would require a world.\nAn example of this is setting the game rules - those are kept in the WorldInfo object,\nwhich is stored in the World, so the overworld specifically needs to be loaded for changing any game rules.\n\nAdditionally, the postWorldCreationCommands and the postWorldLoadingCommands will use\nthe Overworld (or whichever world is dimension 0) for the substitutions.\n\nSo it's mostly the dimension loading commands that benefit from the {DIMENSION} substitution.\n\nNote also, that by default in vanilla/Forge, ALL dimensions use the WorldInfo from the overworld,\nwhich means that they will have the exact same spawn coordinates and game rules etc. as the overworld.\nSome mods may change this so that dimensions can have separate spawn points, game rules etc.\nOne such mod is Just Enough Dimensions.");
        Property prop = conf.get(CATEGORY_GENERIC, "commandSenderName", "WorldPrimer").setRequiresMcRestart(false);
        prop.setComment("The default command sender name used when executing the commands.\nThe name can be overridden per-command by using the prefix 'worldprimer-command-sender \"<name>\"'.\nNote: The quotes are required if the desired name contains spaces!\nThis prefix must come AFTER any possible tracked or dim command\nprefixes, ie. just before the actual command.\nExample command: worldprimer-dim-command-nth 1 123 worldprimer-command-sender \"Tooth Fairy\" say Test Foo Bar Baz in dimension {DIMENSION}");
        commandSenderName = prop.getString();
        prop = conf.get(CATEGORY_GENERIC, "enableChiselsAndBitsCrossWorldFormat", true).setRequiresMcRestart(false);
        prop.setComment("Enables saving any Chisels & Bits blocks in the cross-world compatible format\nin the 'create-structure' command when using the Schematic format");
        enableChiselsAndBitsCrossWorldFormat = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableDebugLogging", false).setRequiresMcRestart(false);
        prop.setComment("Enables verbose logging for debug purposes");
        enableLoggingInfo = prop.getBoolean();
        prop = conf.get(CATEGORY_GENERIC, "enableDataTracking", true).setRequiresMcRestart(false);
        prop.setComment("Enables tracking of dimension load counts, player join counts etc. by storing the counts in a file in worlddir/worldprimer/data_tracker.nbt");
        enableDataTracking = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enableDimensionLoadingCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables the dimension loading commands");
        enableDimensionLoadingCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enableEarlyWorldCreationCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables early world creation commands, which are executed before any dimensions\nhave been loaded and thus before any chunks have been generated or loaded.");
        enableEarlyWorldCreationCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enableEarlyWorldLoadingCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables early world loading commands, which are executed once at each server start,\nbefore the overworld spawn chunks have been loaded.");
        enableEarlyWorldLoadingCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enablePostWorldCreationCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables late world creation commands, which are executed after the overworld spawn chunks have been generated");
        enablePostWorldCreationCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enablePostWorldLoadingCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables late world loading commands, which are executed once at each server start,\nafter the overworld spawn chunks have been loaded.");
        enablePostWorldLoadingCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enableTimedCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables running commands tied to the world time");
        enableTimedCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enablePlayerJoinCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables player join commands");
        enablePlayerJoinCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enablePlayerQuitCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables running the playerQuitCommands");
        enablePlayerQuitCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enablePlayerDeathCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables running the playerDeathCommands");
        enablePlayerDeathCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enablePlayerRespawnCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables running the playerRespawnCommands");
        enablePlayerRespawnCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enablePlayerChangedDimensionEnterCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables running the playerChangedDimensionEnterCommands");
        enablePlayerChangedDimensionEnterCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_TOGGLES, "enablePlayerChangedDimensionLeaveCommands", false).setRequiresMcRestart(false);
        prop.setComment("Enables running the playerChangedDimensionLeaveCommands");
        enablePlayerChangedDimensionLeaveCommands = prop.getBoolean();
        prop = conf.get(CATEGORY_COMMANDS, "dimensionLoadingCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run when a dimension gets loaded.\nYou can target these to only be run when a specific dimension loads\nby specifying the command as 'worldprimer-dim-command <dimId> <command>'.\nSo for example: 'worldprimer-dim-command 1 say The End has loaded!'.\nYou can also run a command only when a dimension loads for specific number of times:\n'worldprimer-dim-command-nth <load count> <dim id> <command>'.\nThis would run the command only when the dimension loads for the 'load count'-th time.\nThe count is incremented before the commands are parsed, so in other words the first load is 1, not 0.\nYou can also run the command every count-th time the dimension loads,\nby prefixing the count with a '%', so for example:\nworldprimer-dim-command-nth %5 1 say The End has loaded some multiple of 5 times!\nAn asterisk '*' can be used as the dimension ID to run\nthe command in all dimensions (mostly makes sense for the nth variant).");
        dimensionLoadingCommands = prop.getStringList();
        prop = conf.get(CATEGORY_COMMANDS, "earlyWorldCreationCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run on initial world creation, before the spawn chunks have been generated or loaded.\nIf dimension load tracking is enabled, then this happens even before any dimensions have been loaded/initialized yet.");
        earlyWorldCreationCommands = prop.getStringList();
        prop = conf.get(CATEGORY_COMMANDS, "earlyWorldLoadingCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run every time the world gets loaded.\nThese are run when the server is starting, before any worlds have been loaded.");
        earlyWorldLoadingCommands = prop.getStringList();
        prop = conf.get(CATEGORY_COMMANDS, "postWorldCreationCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run on initial world creation, after the spawn chunks have been generated and loaded.");
        postWorldCreationCommands = prop.getStringList();
        prop = conf.get(CATEGORY_COMMANDS, "postWorldLoadingCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run every time the world gets loaded.\nThese are run when the server has started and the overworld spawn chunks have been loaded.");
        postWorldLoadingCommands = prop.getStringList();
        prop = conf.get(CATEGORY_COMMANDS, "timedCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run based on the world time.\nMust be in the format: 'worldprimer-timed-command <time> <dimension> <command>',\nwhere <time> is the total world time in ticks when the command should run.\nThe time can be prefixed with a '%' to make it run periodically, with that interval (basically a modulo).\nWith the periodic time, you can also use offsets, like so:\nworldprimer-timed-command %1200-80 0 say Something happens in 4 seconds!\nworldprimer-timed-command %1200 0 say Something happens now!\nworldprimer-timed-command %1200+80 0 Say something happened 4 seconds ago!");
        timedCommands = prop.getStringList();
        TimedCommands.setTimedCommands(timedCommands);
        TimedCommands.updateAllTimedCommands(false);
        prop = conf.get(CATEGORY_COMMANDS, "playerJoinCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run when a player joins (connects to) the server");
        playerJoinCommands = prop.getStringList();
        prop = conf.get(CATEGORY_COMMANDS, "playerQuitCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run when a player disconnects from the server");
        playerQuitCommands = prop.getStringList();
        prop = conf.get(CATEGORY_COMMANDS, "playerDeathCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run when a player dies");
        playerDeathCommands = prop.getStringList();
        prop = conf.get(CATEGORY_COMMANDS, "playerRespawnCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run when a player respawns after dying");
        playerRespawnCommands = prop.getStringList();
        prop = conf.get(CATEGORY_COMMANDS, "playerChangedDimensionEnterCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run when a player enters a dimension while changing dimensions.\nNote that these will NOT run when a player joins the game or respawns after dying.\nYou can use the 'worldprimer-dim-command <dimId>' (or the -nth variant) prefix to target entering a specific dimension.");
        playerChangedDimensionEnterCommands = prop.getStringList();
        prop = conf.get(CATEGORY_COMMANDS, "playerChangedDimensionLeaveCommands", new String[0]).setRequiresMcRestart(false);
        prop.setComment("Commands to run when a player leaves a dimension while changing dimensions.\nNote that these will NOT run when a player leaves the game/server.\nYou can use the 'worldprimer-dim-command <dimId>' (or the -nth variant) prefix to target leaving a specific dimension.\nNOTE: These commands will run AFTER the player is already in the new dimension!!");
        playerChangedDimensionLeaveCommands = prop.getStringList();
        if (conf.hasChanged()) {
            conf.save();
        }
    }
}

