/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.idsu;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.StringUtils;
import reborncore.api.power.EnumPowerTier;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import techreborn.init.ModBlocks;
import techreborn.tiles.idsu.IDSUManager;
import techreborn.tiles.storage.TileEnergyStorage;

@RebornRegistry(modID="techreborn")
public class TileInterdimensionalSU
extends TileEnergyStorage
implements IContainerProvider {
    @ConfigRegistry(config="machines", category="idsu", key="IdsuMaxInput", comment="IDSU Max Input (Value in EU)")
    public static int maxInput = 8192;
    @ConfigRegistry(config="machines", category="idsu", key="IdsuMaxOutput", comment="IDSU Max Output (Value in EU)")
    public static int maxOutput = 8192;
    @ConfigRegistry(config="machines", category="idsu", key="IdsuMaxEnergy", comment="IDSU Max Energy (Value in EU)")
    public static int maxEnergy = 100000000;
    public String ownerUdid;

    public TileInterdimensionalSU() {
        super("IDSU", 2, ModBlocks.INTERDIMENSIONAL_SU, EnumPowerTier.EXTREME, maxInput, maxOutput, maxEnergy);
    }

    public double getEnergy() {
        if (this.ownerUdid == null || this.ownerUdid.isEmpty()) {
            return 0.0;
        }
        return IDSUManager.getData(this.field_145850_b).getStoredPower();
    }

    public void setEnergy(double energy) {
        if (this.ownerUdid == null || this.ownerUdid.isEmpty()) {
            return;
        }
        IDSUManager.getData(this.field_145850_b).setStoredPower(energy);
    }

    public double useEnergy(double extract, boolean simulate) {
        if (this.ownerUdid == null || this.ownerUdid.isEmpty()) {
            return 0.0;
        }
        double energy = IDSUManager.getData(this.field_145850_b).getStoredPower();
        if (extract > energy) {
            extract = energy;
        }
        if (!simulate) {
            this.setEnergy(energy - extract);
        }
        return extract;
    }

    public boolean canUseEnergy(double input) {
        if (this.ownerUdid == null || this.ownerUdid.isEmpty()) {
            return false;
        }
        return input <= IDSUManager.getData(this.field_145850_b).getStoredPower();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.ownerUdid = nbttagcompound.func_74779_i("ownerUdid");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        if (this.ownerUdid == null && StringUtils.isBlank((CharSequence)this.ownerUdid) || StringUtils.isEmpty((CharSequence)this.ownerUdid)) {
            return nbttagcompound;
        }
        nbttagcompound.func_74778_a("ownerUdid", this.ownerUdid);
        return nbttagcompound;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("idsu").player(player.field_71071_by).inventory().hotbar().armor().complete(8, 18).addArmor().addInventory().tile((IInventory)this).energySlot(0, 62, 45).energySlot(1, 98, 45).syncEnergyValue().syncIntegerValue(this::getRedstoneModeInt, this::setRedstoneModeInt).addInventory().create((TileLegacyMachineBase)this);
    }

    public boolean shouldHanldeEnergyNBT() {
        return false;
    }
}

