/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.event.mobtweaks;

import com.oitsjustjose.vtweaks.event.mobtweaks.ChallengerMobType;
import com.oitsjustjose.vtweaks.util.HelperFunctions;
import com.oitsjustjose.vtweaks.util.ModConfig;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChallengerMobs {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void registerEvent(LivingSpawnEvent event) {
        if (!ModConfig.mobTweaks.challengerMobs.enabled || ModConfig.mobTweaks.challengerMobs.chance <= 0) {
            return;
        }
        if (!event.getWorld().field_72995_K && event.getWorld().field_73012_v.nextInt(ModConfig.mobTweaks.challengerMobs.chance) == 0) {
            ChallengerMobType VARIANT = ChallengerMobType.values()[event.getWorld().field_73012_v.nextInt(8)];
            if (event.getEntity() != null && event.getEntity() instanceof EntityMob) {
                if (event.getEntity() instanceof EntityPigZombie || this.isBlackListed(event.getEntity())) {
                    return;
                }
                EntityMob monster = (EntityMob)event.getEntity();
                monster.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                monster.func_184201_a(EntityEquipmentSlot.CHEST, ItemStack.field_190927_a);
                monster.func_184201_a(EntityEquipmentSlot.LEGS, ItemStack.field_190927_a);
                monster.func_184201_a(EntityEquipmentSlot.FEET, ItemStack.field_190927_a);
                monster.func_96094_a(this.mobClassName(VARIANT, monster));
                if (!(monster instanceof EntityCreeper)) {
                    monster.func_70690_d(new PotionEffect((Potion)Objects.requireNonNull(Potion.field_188414_b.func_82594_a((Object)new ResourceLocation("fire_resistance"))), Integer.MAX_VALUE, 0, true, true));
                }
                monster.func_184611_a(EnumHand.MAIN_HAND, VARIANT.getEquipment());
                monster.func_184642_a(EntityEquipmentSlot.MAINHAND, Float.MIN_VALUE);
                monster.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(VARIANT.getSpeed());
                monster.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)VARIANT.getHealth());
                monster.func_70606_j(VARIANT.getHealth());
                if (VARIANT == ChallengerMobType.ZESTONIAN) {
                    ItemStack pants = new ItemStack((Item)Items.field_151149_ai);
                    pants.func_151001_c("Man Pants");
                    pants.func_77966_a(HelperFunctions.getEnchantment("minecraft", "blast_protection"), 5);
                    monster.func_184201_a(EntityEquipmentSlot.LEGS, pants);
                }
            }
        }
    }

    @SubscribeEvent
    public void registerEvent(LivingDropsEvent event) {
        if (!ModConfig.mobTweaks.challengerMobs.enabled || ModConfig.mobTweaks.challengerMobs.loot.length <= 0) {
            return;
        }
        if (event.getEntity() == null || !(event.getEntity() instanceof EntityMob) || !this.isChallengerMob((EntityMob)event.getEntity())) {
            return;
        }
        event.getDrops().add(this.getItem(event.getEntity().field_70170_p, event.getEntity().func_180425_c()));
    }

    private boolean isBlackListed(Entity entity) {
        for (String s : ModConfig.mobTweaks.challengerMobs.blacklist) {
            if (!entity.getClass().getName().toLowerCase().contains(s.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private String mobClassName(ChallengerMobType type, EntityMob mob) {
        StringBuilder mobString = new StringBuilder(mob.toString().substring(0, mob.toString().indexOf("[")));
        String[] nameParts = mobString.toString().split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        mobString = new StringBuilder();
        for (int i = 0; i < nameParts.length; ++i) {
            if (nameParts[i].toLowerCase().contains("entity")) continue;
            if (i != nameParts.length - 1) {
                mobString.append(nameParts[i]).append(" ");
                continue;
            }
            mobString.append(nameParts[i]);
        }
        return type.getPrefix() + " " + mobString;
    }

    private EntityItem getItem(World world, BlockPos pos) {
        int RNG = world.field_73012_v.nextInt(ModConfig.MobTweaks.ChallengerMobs.challengerLootTable.size());
        return HelperFunctions.createItemEntity(world, pos, ModConfig.MobTweaks.ChallengerMobs.challengerLootTable.get(RNG));
    }

    private boolean isChallengerMob(EntityMob entity) {
        String n = entity.func_95999_t();
        for (ChallengerMobType type : ChallengerMobType.values()) {
            if (!n.startsWith(type.getPrefix())) continue;
            return true;
        }
        return false;
    }
}

