/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.enchantment.handler;

import com.oitsjustjose.vtweaks.enchantment.Enchantments;
import com.oitsjustjose.vtweaks.util.ModConfig;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentLumberingHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void register(BlockEvent.BreakEvent event) {
        if (!ModConfig.enchantments.enableLumbering) {
            return;
        }
        if (event.getState() == null || event.getWorld() == null || event.getPlayer() == null || event.getPlayer().func_184614_ca().func_190926_b() || event.getPlayer().field_71075_bZ.field_75098_d) {
            return;
        }
        World world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.getInstance().lumbering, (ItemStack)player.func_184614_ca()) > 0 && player.func_70093_af() && event.getState().func_177230_c().isWood((IBlockAccess)world, event.getPos())) {
            this.chopTree(world, player, event.getPos());
            world.func_184133_a(null, event.getPos(), event.getState().func_177230_c().getSoundType(event.getState(), world, event.getPos(), (Entity)player).func_185845_c(), SoundCategory.BLOCKS, 0.25f, 0.8f);
        }
    }

    private boolean chopTree(World world, EntityPlayer player, BlockPos pos) {
        for (int mod_x = -1; mod_x <= 1; ++mod_x) {
            for (int mod_y = -1; mod_y <= 1; ++mod_y) {
                for (int mod_z = -1; mod_z <= 1; ++mod_z) {
                    BlockPos iterPos = pos.func_177982_a(mod_x, mod_y, mod_z);
                    if (iterPos == pos) continue;
                    if (!this.canStillChop(player)) {
                        return false;
                    }
                    if (world.func_180495_p(iterPos).func_177230_c().isWood((IBlockAccess)world, iterPos)) {
                        world.func_175655_b(iterPos, true);
                        player.func_184614_ca().func_96631_a(1, player.func_70681_au(), null);
                        if (this.chopTree(world, player, iterPos)) continue;
                        return false;
                    }
                    if (!ModConfig.enchantments.lumberingCutsLeaves || !world.func_180495_p(iterPos).func_177230_c().isLeaves(world.func_180495_p(iterPos), (IBlockAccess)world, iterPos)) continue;
                    world.func_175655_b(iterPos, true);
                    if (this.chopTree(world, player, iterPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean canStillChop(EntityPlayer player) {
        if (player.func_184614_ca().func_190926_b()) {
            return false;
        }
        if (player.func_184614_ca().func_77952_i() >= player.func_184614_ca().func_77958_k() - 2) {
            return false;
        }
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.getInstance().lumbering, (ItemStack)player.func_184614_ca()) > 0;
    }
}

