/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import java.util.List;
import java.util.Random;

public class AboveWaterGen
extends Resource {
    public AboveWaterGen(BiomeConfig config, List<String> args) throws InvalidConfigException {
        super(config);
        this.assureSize(3, args);
        this.material = this.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        int y = world.getLiquidHeight(x, z);
        if (y == -1) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int m;
            int k;
            int j = x + rand.nextInt(8) - rand.nextInt(8);
            if (!world.isNullOrAir(j, k = y + rand.nextInt(4) - rand.nextInt(4), m = z + rand.nextInt(8) - rand.nextInt(8), false) || !world.getMaterial(j, k - 1, m, false).isLiquid()) continue;
            world.setBlock(j, k, m, this.material, null, false);
        }
    }

    @Override
    public String toString() {
        return "AboveWaterRes(" + this.material + "," + this.frequency + "," + this.rarity + ")";
    }

    @Override
    public int getPriority() {
        return -11;
    }
}

